% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarianceMatrix.R
\name{createVarianceMatrix}
\alias{createVarianceMatrix}
\title{Compute the variance matrix}
\usage{
createVarianceMatrix(model, which, times1, times2, nmes)
}
\arguments{
\item{model}{an object inheriting from class \code{hlme}, \code{lcmm}, 
\code{Jointlcmm} or \code{multlcmm} representing a general latent class
mixed model.}

\item{which}{either "random", "cor", "randomY", or "error".}

\item{times1}{for \code{which = "cor"}, numeric vector containing the times at which the correlation should be computed}

\item{times2}{for \code{which = "cor"}, numeric vector containing the times at which the correlation should be computed}

\item{nmes}{for \code{which = "randomY"} and \code{which = "error"}, the number of measures (ie, the dimension of the returned variance matrix)}
}
\value{
a matrix
}
\description{
The function computes the variance matrix of the random effects, the correlations, or the measurement error.
}
\examples{
\dontrun{
 ## The model
 m <- hlme(fixed = Y ~ Time, mixture = ~1, random = ~1, subject = "ID",
  ng = 2, cor = BM(Time), data = data_hlme, B = c(0,20,30,-1,5,2,0.1))

## The random effects' variance matrix (the variance of the random intercept )
B <- createVarianceMatrix(m, which = "random")

## The variance of the Brownian motion at time c(1, 2, 3, 4) 
W <- createVarianceMatrix(m, which = "cor", times1 = c(1, 2, 3, 4), times2 = c(1, 2, 3, 4))

## The variance of the measurement error at 4 visit times
S <- createVarianceMatrix(m, which = "error", nmes = 4)

## In model "m", the variance matrix of the outcome at times c(1, 2, 3, 4) is:
matrix(1, nrow = 4) \%*\% B \%*\% t(matrix(1, nrow = 4)) + W + S
}
}
\author{
Viviane Philipps
}
