# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Rcpp function to compute sum of rows and couple according to alphavec
#'
#' @param mc a matrix of Archimedean vectors to share of dimension \code{sum(alphavec)}
#' @param alphavec vector of Dirichlet allocations (must be a vector of integers)
#' 
#' @keywords internal
#' 
#' @return a matrix of dimension \code{n} by \code{length(alphavec)} with combined data
.marginCombo <- function(alphavec, mc) {
    .Call('_lcopula_marginCombo', PACKAGE = 'lcopula', alphavec, mc)
}

#' Spectral density of scaled Dirichlet and negative Dirichlet extreme value distributions
#'
#' @param param vector containing the parameters \eqn{\alpha} and \eqn{\rho}, in this order.
#' @param dat matrix of Frechet or Pareto observations, of dimension \eqn{n} by \eqn{d}.
#' @param d dimension of model
#' @param transform logical indicating whether parameters are on the log scale. Default to \code{TRUE}
#'
#' @details The function is provided as a wrapper and takes parameters on the log scale for \eqn{\alpha} (\eqn{\rho}).
#' @return the log-likelihood for the \code{n} sample
dirspecdens <- function(param, dat, d, transform = TRUE) {
    .Call('_lcopula_dirspecdens', PACKAGE = 'lcopula', param, dat, d, transform)
}

#' Spectral density of scaled negative Dirichlet extreme value distribution
#'
#' @param param vector containing the parameters \eqn{\alpha} and \eqn{\rho}, in this order.
#' @param dat matrix of Frechet or Pareto observations, of dimension \eqn{n} by \eqn{d}.
#' @param d dimension of model
#' @param transform logical indicating whether parameters are on the log scale. Default to \code{TRUE}
#'
#' @details The function is provided as a wrapper and takes parameters on the log scale for \eqn{\alpha} and \eqn{\rho}.
#' @return the log-likelihood for the \code{n} sample
negdirspecdens <- function(param, dat, d, transform = TRUE) {
    .Call('_lcopula_negdirspecdens', PACKAGE = 'lcopula', param, dat, d, transform)
}

#' Spectral density of Coles and Tawn extreme value distribution
#'
#' @param param vector containing the parameters \eqn{\alpha}.
#' @param dat matrix of pseudo-dat, of dimension \eqn{d}
#' @param transform logical indicating whether parameters are on the log scale. Default to \code{TRUE}
#' @return the value of the log likelihood for a sample of size \code{n}
.ctspecdens <- function(param, dat, transform = TRUE) {
    .Call('_lcopula_ctspecdens', PACKAGE = 'lcopula', param, dat, transform)
}

