% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geosearch.R
\name{geosearchOptions}
\alias{geosearchOptions}
\title{geosearchOptions}
\usage{
geosearchOptions(
  style = c("button", "bar"),
  resetButton = "x",
  notFoundMessage = "Nothing found",
  autoComplete = TRUE,
  autoCompleteDelay = 250,
  showMarker = TRUE,
  showPopup = FALSE,
  maxMarkers = 1,
  retainZoomLevel = FALSE,
  animateZoom = TRUE,
  autoClose = FALSE,
  searchLabel = "Enter address",
  keepResult = FALSE,
  updateMap = TRUE,
  ...
)
}
\arguments{
\item{style}{Character. UI style, one of "bar" or "button".}

\item{resetButton}{Icon or Character for the reset button.}

\item{notFoundMessage}{Message shown if no result is found.}

\item{autoComplete}{Logical. Enable autocomplete suggestions.}

\item{autoCompleteDelay}{Delay in ms before suggestions appear.}

\item{showMarker}{Logical. Show marker for result location.}

\item{showPopup}{Logical. Show popup on result location.}

\item{maxMarkers}{Max number of markers shown.}

\item{retainZoomLevel}{Logical.}

\item{animateZoom}{Logical.}

\item{autoClose}{Logical. Close results after selection.}

\item{searchLabel}{Placeholder text.}

\item{keepResult}{Logical. Keep last result shown.}

\item{updateMap}{Logical. Pan/zoom map on result.}

\item{...}{Further arguments passed to `addGeosearch`}
}
\value{
A list of options for \code{addGeosearch}
}
\description{
Add extra options. For a full list please visit the
\href{https://smeijer.github.io/leaflet-geosearch/}{plugin repository} or see
the
\href{https://github.com/smeijer/leaflet-geosearch/blob/main/src/SearchControl.ts#L23}{source code}
}
\seealso{
Other Geosearch Functions: 
\code{\link{addGeosearch}()},
\code{\link{removeGeosearch}()}
}
\concept{Geosearch Functions}
