test_that("Error is returned when legislature argument is not specified", {
  skip_on_cran()
  expect_error(get_core())
  expect_error(get_political())
  expect_error(get_history())
  expect_error(get_traffic())
  expect_error(get_social())
  expect_error(get_portrait())
  expect_error(get_office())
  expect_error(get_profession())
  expect_error(get_ids())
})

test_that("Error is returned when legislature argument is not a valid country code", {
  skip_on_cran()
  expect_error(get_core(NA))
  expect_error(get_political(NA))
  expect_error(get_history(NA))
  expect_error(get_traffic(NA))
  expect_error(get_social(NA))
  expect_error(get_portrait(NA))
  expect_error(get_office(NA))
  expect_error(get_profession(NA))
  expect_error(get_ids(NA))

  expect_error(get_core("bla"))
  expect_error(get_political("bla"))
  expect_error(get_history("bla"))
  expect_error(get_traffic("bla"))
  expect_error(get_social("bla"))
  expect_error(get_portrait("bla"))
  expect_error(get_office("bla"))
  expect_error(get_profession("bla"))
  expect_error(get_ids("bla"))

  expect_error(get_core(2))
  expect_error(get_political(2))
  expect_error(get_history(2))
  expect_error(get_traffic(2))
  expect_error(get_social(2))
  expect_error(get_portrait(2))
  expect_error(get_office(2))
  expect_error(get_profession(2))
  expect_error(get_ids(2))

  expect_error(get_core(TRUE))
  expect_error(get_political(TRUE))
  expect_error(get_history(TRUE))
  expect_error(get_traffic(TRUE))
  expect_error(get_social(TRUE))
  expect_error(get_portrait(TRUE))
  expect_error(get_office(TRUE))
  expect_error(get_profession(TRUE))
  expect_error(get_ids(TRUE))
})

test_that("Error is returned when more than one country code is specified in legislature argument ", {
  skip_on_cran()
  expect_error(get_core(c("aut","deu")))
  expect_error(get_political(c("aut","deu")))
  expect_error(get_history(c("aut","deu")))
  expect_error(get_traffic(c("aut","deu")))
  expect_error(get_social(c("aut","deu")))
  expect_error(get_portrait(c("aut","deu")))
  expect_error(get_office(c("aut","deu")))
  expect_error(get_profession(c("aut","deu")))
  expect_error(get_ids(c("aut","deu")))
})



