% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_project.R
\name{new_project}
\alias{new_project}
\title{Create a new project}
\usage{
new_project()
}
\value{
A project containing folders and files for reproducible purposes.
}
\description{
This function sets up a new project within an \strong{active R project}
for reproducible purposes.
}
\details{
The project includes:
\itemize{
\item \strong{README.md}: the top level description of content in the project
\item \strong{Makefile}
\item different folders to hold all \emph{data}, \emph{code}, \emph{results} of data analysis,
and \emph{documents} related to the project
\item templates: \strong{manuscript.Rmd}, \strong{code.R}, etc.
}
}
\note{
The function should be executed within an \strong{active project}.

Recommended workflow:
\enumerate{
\item Create a GitHub repository for the new project.
At \emph{Initialize this repository with a README}, choose NO.
\item Create a new RStudio Project via \verb{git clone}.
\item Use function \code{new_project()} to generate folders and file templates.
}
}
\examples{
\donttest{

if(interactive()){
  new_project()
}
}
}
\references{
\href{https://riffomonas.org/reproducible_research/}{Reproducibile Research Tutorial Series}
by Pat Schloss.
}
