% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array-lenses.R
\name{slab_l}
\alias{slab_l}
\title{Slab lens}
\usage{
slab_l(..., drop = FALSE)
}
\arguments{
\item{...}{arguments as they would be passed to \code{[} for example \code{x[3,5,7]}.}

\item{drop}{whether or not to drop dimensions with length 1. Only
applies to \code{view}.}
}
\description{
Create a lens into a chunk of an array (hyperslab). Uses
the same syntactic rules as \code{[}.
}
\examples{
(x <- matrix(1:4, ncol = 2))
view(x, slab_l(2,)) # x[2,, drop = FALSE]
view(x, slab_l(2, 2)) # x[2,2, drop = FALSE]
set(x, slab_l(1,1:2), c(10,20))
}
