% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifiers.R
\name{RandomForestClassifier}
\alias{RandomForestClassifier}
\title{RandomForestClassifier}
\value{
R6 Class of RandomForestClassifier
}
\description{
Wrapper R6 Class of randomForest::randomForest function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `RandomForestClassifier$new`
## ------------------------------------------------

rf <- RandomForestClassifier$new()
rf <- RandomForestClassifier$new(n_estimators = 500)
rf <- RandomForestClassifier$new(n_estimators = 500, random_state = 100)

## ------------------------------------------------
## Method `RandomForestClassifier$fit`
## ------------------------------------------------

data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

rf <- RandomForestClassifier$new()
rf$fit(X_train, y_train)

## ------------------------------------------------
## Method `RandomForestClassifier$predict`
## ------------------------------------------------

rf <- RandomForestClassifier$new()
rf$fit(X_train, y_train)
preds <- rf$predict(X_test)

rf <- RandomForestClassifier$new()
preds <- rf$fit(X_train, y_train)$predict(X_test)

preds <- RandomForestClassifier$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=preds, reference = factor(y_test)))

## ------------------------------------------------
## Method `RandomForestClassifier$get_estimator_type`
## ------------------------------------------------

rf$get_estimator_type()
}
\seealso{
\code{\link[randomForest:randomForest]{randomForest::randomForest()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{RandomForestClassifier}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RandomForestClassifier-new}{\code{RandomForestClassifier$new()}}
\item \href{#method-RandomForestClassifier-fit}{\code{RandomForestClassifier$fit()}}
\item \href{#method-RandomForestClassifier-predict}{\code{RandomForestClassifier$predict()}}
\item \href{#method-RandomForestClassifier-get_estimator_type}{\code{RandomForestClassifier$get_estimator_type()}}
\item \href{#method-RandomForestClassifier-clone}{\code{RandomForestClassifier$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestClassifier-new"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestClassifier-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of RandomForestClassifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestClassifier$new(
  n_estimators = 100,
  random_state = NULL,
  min_samples_leaf = 1,
  max_leaf_nodes = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_estimators}}{Number of trees to grow. This should not be set to too small a number,
to ensure that every input row gets predicted at least a few times (defaults to 100).}

\item{\code{random_state}}{Seed number to be used for fixing the randomness (default to NULL).}

\item{\code{min_samples_leaf}}{Minimum size of terminal nodes. Setting this number larger causes smaller trees to be grown
(and thus take less time) (defaults to 1)}

\item{\code{max_leaf_nodes}}{Maximum number of terminal nodes trees in the forest can have.
If not given, trees are grown to the maximum possible (subject to limits by nodesize).
If set larger than maximum possible, a warning is issued. (defaults to NULL)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rf <- RandomForestClassifier$new()
rf <- RandomForestClassifier$new(n_estimators = 500)
rf <- RandomForestClassifier$new(n_estimators = 500, random_state = 100)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestClassifier-fit"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestClassifier-fit}{}}}
\subsection{Method \code{fit()}}{
Builds a random forest regressor from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestClassifier$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes labels}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of RandomForestClassifier
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

rf <- RandomForestClassifier$new()
rf$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestClassifier-predict"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestClassifier-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestClassifier$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Factor of the predict classes.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rf <- RandomForestClassifier$new()
rf$fit(X_train, y_train)
preds <- rf$predict(X_test)

rf <- RandomForestClassifier$new()
preds <- rf$fit(X_train, y_train)$predict(X_test)

preds <- RandomForestClassifier$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=preds, reference = factor(y_test)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestClassifier-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestClassifier-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestClassifier$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rf$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestClassifier-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestClassifier-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestClassifier$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
