% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/herpSearch.R
\name{herpSearch}
\alias{herpSearch}
\title{Search for a Single Reptile Species in The Reptile Database (RDB)}
\usage{
herpSearch(binomial=NULL, ref=FALSE, verbose=TRUE)
}
\arguments{
\item{binomial}{Character string. The valid binomial name of a reptile species (e.g., "Boa constrictor").}

\item{ref}{Logical. If \code{TRUE}, returns the list of references from RDB associated with the species. Default is \code{FALSE}.}

\item{verbose}{Logical. If \code{TRUE}, prints species information in the console. Default is \code{TRUE}.}
}
\value{
A list containing species information retrieved from The Reptile Database. If \code{ref = TRUE}, returns references related to the species.
}
\description{
Queries The Reptile Database (RDB) for information about a single reptile species using its binomial name.
}
\examples{
\donttest{
herpSearch("Boa constrictor")
herpSearch("Boa constrictor", ref = TRUE)
}

}
\references{
Uetz, P., Freed, P., & Hošek, J. (Eds.). (2025). The Reptile Database. Retrieved from \url{http://www.reptile-database.org}
}
\seealso{
\code{\link{herpSynonyms}}, \code{\link{herpSpecies}} for related species data functions.
}
