% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lev-distance.R
\name{internal-functions}
\alias{internal-functions}
\alias{internal_lev_token_set_ratio}
\alias{internal_lev_partial_ratio}
\title{Internal functions}
\usage{
internal_lev_token_set_ratio(a, b, pairwise = TRUE, useNames = !pairwise, ...)

internal_lev_partial_ratio(a, b, pairwise = TRUE, useNames = !pairwise, ...)
}
\arguments{
\item{a, b}{The input strings. For these "internal" functions these must be length 1}

\item{pairwise}{Boolean. If \code{TRUE}, only the pairwise distances between \code{a} and \code{b} will be
computed, rather than the combinations of all elements.}

\item{useNames}{Boolean. Use input vectors as row and column names?}

\item{...}{Additional arguments to be passed to \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} or
\code{\link[stringdist:stringsim]{stringdist::stringsimmatrix()}}.}
}
\description{
\code{\link[=lev_partial_ratio]{lev_partial_ratio()}} and \code{\link[=lev_token_set_ratio]{lev_token_set_ratio()}} are hard to vectorise in one go, so in the
interests of lazy thinking these "internal" versions contain the logic to operate on
single-length inputs, and the calling functions just \code{\link[=apply]{apply()}} them as needed.
}
\section{Functions}{
\itemize{
\item \code{internal_lev_token_set_ratio()}: See \code{\link[=lev_token_set_ratio]{lev_token_set_ratio()}}.

\item \code{internal_lev_partial_ratio()}: See \code{\link[=lev_partial_ratio]{lev_partial_ratio()}}.

}}
\keyword{internal}
