% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranking.R
\name{lev_score_multiple}
\alias{lev_score_multiple}
\title{Score multiple candidate strings against a single input}
\usage{
lev_score_multiple(input, candidates, .fn = lev_ratio, ..., decreasing = TRUE)
}
\arguments{
\item{input}{A single string}

\item{candidates}{One or more candidate strings to score}

\item{.fn}{The scoring function to use, as a string or function object. Defaults to
\code{\link[=lev_ratio]{lev_ratio()}}.}

\item{...}{Additional arguments to pass to \code{.fn}.}

\item{decreasing}{If \code{TRUE} (the default), the candidate with the highest score is ranked first.
If using a comparison \code{.fn} that computes \emph{distance} rather than similarity, or if you want the
worst match to be returned first, set this to \code{FALSE}.}
}
\value{
A list where the keys are \code{candidates} and the values are the scores. The list is sorted
according to the \code{decreasing} parameter, so by default higher scores are first.
}
\description{
Given a single \code{input} string and multiple \code{candidates}, compute scores for each candidate.
}
\examples{
lev_score_multiple("bilbo", c("frodo", "gandalf", "legolas"))
}
\seealso{
\code{\link[=lev_best_match]{lev_best_match()}}
}
