% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi_lfc.R
\name{PsiLFC}
\alias{PsiLFC}
\title{Psi LFC effect size estimator}
\usage{
PsiLFC(
  A,
  B,
  prior = EmpiricalBayesPrior(A, B),
  normalizeFun = CenterMedian,
  cre = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{A}{Vector of counts from condition A}

\item{B}{Vector of counts from condition B}

\item{prior}{Vector of length 2 of the prior parameters}

\item{normalizeFun}{Function to normalize the obtained effect sizes}

\item{cre}{Compute credible intervals as well? (can also be a vector of quantiles)}

\item{verbose}{verbose status updates?}
}
\value{
Either a vector containing the estimates, or a data frame containing
    the credible interval as well
}
\description{
Computes the optimal effect size estimate and credible intervals if needed.
}
\examples{
  PsiLFC(rnorm(1000,200),rnorm(1000,100))
}
