% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharedFunction.R
\name{mle}
\alias{mle}
\title{Maximum Likelihood Estimate of Precision Matrix and Correlation Parameters for Given Network}
\usage{
mle(
  data,
  network,
  heter = TRUE,
  type = 1,
  tole = 0.01,
  lower = 0.01,
  upper = 10
)
}
\arguments{
\item{data}{Data matrix  in which the first column is subject id, the second column is
time points of observations for temporal data or site id for spatial data.
 Columns \code{3} to \code{(p+2)} is the observations for \code{p} variables.}

\item{network}{The network selected by function lglasso}

\item{heter}{Binary variable \code{TRUE} or \code{FALSE}, indicating heterogeneous model or homogeneous model is fitted. In heterogeneous model,
subjects are allowed to have his/her own temporal correlation parameter \code{tau_i}; while in homogeneous model, all the subjects are assumed to
 share the same temporal correlation parameter,i.e., \code{tau_1=tau_2=...tau_m}.}

\item{type}{A positive number which specify the correlation function. The general form of correlation function  is given by \code{ exp(tau|t_i-t_j|^type)}.
in which \code{type=0} can be used for spatial correlation while \code{type>0} are used for temporal correlation. For latter, the default value is set to be \code{type=1}.}

\item{tole}{Threshold for convergence. Default value is \code{1e-2}. Iterations stop when maximum
absolute difference between consecutive estimates of parameter change is less than \code{tole}.}

\item{lower}{Lower bound for predicts of correlation parameter \code{tau}.
Default value is \code{1e-2}. The estimate of \code{tau}(\code{alpha}) will be searched in the
interval \code{[lower,upper]}, where parameter \code{upper} is explained in the following.}

\item{upper}{Upper bound for predicts of correlation parameter \code{tau}.}
}
\value{
A list which include the maximum likelihood estimate of precision matrix, correlation parameter \code{tau}. If \code{heter=TRUE},
the output also include the estimate of alpha where \code{tau~exp(alpha)}
}
\description{
Maximum Likelihood Estimate of Precision Matrix and Correlation Parameters for Given Network
}
\author{
Jie Zhou
}
