% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call-numbers-and-subject.R
\name{get_dewey_decimal_subject_section}
\alias{get_dewey_decimal_subject_section}
\title{Conversion from Dewey Decimal call numbers to third-level subject description}
\usage{
get_dewey_decimal_subject_section(x)
}
\arguments{
\item{x}{A Dewey Decimal call number}
}
\value{
Returns the most general subject sectionification using the
        first three digits from the DDC. Returns NA if the DDC looks
        invalid
}
\description{
Takes a string representation of a Dewey Decimal
call number (DDC) and returns it's subject description.
This uses the first three digits of the DDC number
and returns the third most general subject classification.
}
\examples{

get_dewey_decimal_subject_section("709.05")
# "History, geographic treatment, biography"

get_dewey_decimal_subject_section("823.912")
# "English fiction"

# vectorized
get_dewey_decimal_subject_section(c("709.05", "invalid", NA, "823.912"))
# c("History, geographic treatment, biography", NA, NA,
#   "English fiction")

}
