% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapSites.R
\name{CoordInBounds}
\alias{CoordInBounds}
\title{Determine if coordinate is in bounds, and if not, return valid value}
\usage{
CoordInBounds(x, latitude)
}
\arguments{
\item{x}{numeric four coordinates of bounding box in decimal degrees}

\item{latitude}{logical vector of length four indicating whether each 
element in \code{x} is latitude or not (i.e. is longitude)}
}
\value{
a copy of the original numeric vector of decimal degrees, \code{x}, 
with any invalid values (i.e. a latitude > 90) corrected to their closest 
valid value
}
\description{
Determine if coordinate is in bounds, and if not, return valid value
}
\details{
A helper function designed to keep map bounds from using invalid 
coordinates (latitudes outside of -90 and 90; longitudes outside of -180 and 
180). Will round values to nearest valid value. A more feature-rich approach 
could treat longitudes a little more carefully, where values outside the 
range are updated with the antimeridian in mind. For example, a longitude of 
182 would become -178. However, drawing polygons that include the 
antimeridian are a nightmare, and since that is what will be done with this 
helper function, it will simply round down to 180.
}
\keyword{internal}
