% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentification.R
\name{lx_save_token}
\alias{lx_save_token}
\title{save a lifx API token in your r environment file}
\usage{
lx_save_token(token)
}
\arguments{
\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
logical TRUE if saving token has been successful
}
\description{
save a lifx API token in your r environment file
}
\details{
To use the 'LIFX' API, you need to get a personal access token from your 'LIFX' account. Usually you save API tokens in your r environment file; that way you only have to enter it once per system.
How to get a token:
1. go to \url{https://cloud.lifx.com/sign_in} and sign in (if you do not have an account, you must download the mobile app and register there.
2. generate or look up your access token

You do not need to save the token in the environment; you can use all functions in this package by passing a valid `token` argument.
}
\examples{
\dontrun{
lx_save_token("asodfjawea9499fao8u4a09fw0s8fu439wfrsud7") # put your token here
}
}
\seealso{
\code{\link{lx_has_token}}, \code{\link{lx_get_token}}
}
