% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{Linne}
\alias{Linne}
\title{Linne}
\description{
Generate CSS from R code. Initialise a new CSS environment with \code{new},
use \code{rule} to define CSS rules.
}
\section{Attributes}{

There are hundreds of attributes to pass to the three-dot
construct (\code{...}), a comprehensive list of them can be found on
\href{https://www.w3schools.com/cssref/}{w3schools}.

Note that Linne accepts camelCase for convenience, e.g.: \code{font-size} or \code{fontSize}.
}

\examples{

## ------------------------------------------------
## Method `Linne$define`
## ------------------------------------------------

Linne$new()$define(baseColor = "blue")

## ------------------------------------------------
## Method `Linne$rule`
## ------------------------------------------------

Linne$new()$rule(sel_id("myButton"), color = "blue", fontSize = 50)

## ------------------------------------------------
## Method `Linne$build`
## ------------------------------------------------

Linne$
 new()$
 define(primary_color = 'red')$
 rule(
   sel_id("myButton"), 
   color = primary_color, 
   fontSize = 50
 )$
 rule(
   sel_class("container"),
   backgroundColor = primary_color
 )$
 build()

## ------------------------------------------------
## Method `Linne$get_css`
## ------------------------------------------------

Linne$new()$rule(sel_id("myId"), fontSize = 20)$get_css()

## ------------------------------------------------
## Method `Linne$show_css`
## ------------------------------------------------

Linne$new()$rule(sel_id("myButton"), color = "blue")$show_css()

## ------------------------------------------------
## Method `Linne$import`
## ------------------------------------------------

Linne$new()$import('https://fonts.googleapis.com/css2?family=Roboto')

## ------------------------------------------------
## Method `Linne$include`
## ------------------------------------------------

# generate CSS
css <- Linne$
  new()$
  define(grey = '#c4c4c4')$
  rule(
    sel_id("myButton"), 
    backgroundColor = 'red', 
    fontSize = 20,
    color = grey
  )$
  rule(
    sel_class("aClass"),
    color = grey
  )

# include in an app
library(shiny)

ui <- fluidPage(
  css$include(),
  h1("Some text", class = "aClass"),
  actionButton("myButton", "Am I red?", class = "aClass")
)

server <- function(input, output){
  output$myPlot <- renderPlot(plot(cars))
}

if(interactive())
 shinyApp(ui, server)


## ------------------------------------------------
## Method `Linne$write`
## ------------------------------------------------

if(interactive()) 
 Linne$new()$rule(sel_id("id"), fontStyle = "italic")$write("styles.css")

## ------------------------------------------------
## Method `Linne$inject`
## ------------------------------------------------

library(shiny)

ui <- fluidPage(
  useLinne(),
  actionButton("change", "Change me!")
)

server <- function(input, output){

  linne <- Linne$
    new()$
    rule(
      sel_id("change"),
      color = "white",
      backgroundColor = "black"
    )

  observeEvent(input$change, {
    linne$inject()
  })

}

if(interactive())
 shinyApp(ui, server)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-define}{\code{Linne$define()}}
\item \href{#method-rule}{\code{Linne$rule()}}
\item \href{#method-build}{\code{Linne$build()}}
\item \href{#method-get_css}{\code{Linne$get_css()}}
\item \href{#method-show_css}{\code{Linne$show_css()}}
\item \href{#method-import}{\code{Linne$import()}}
\item \href{#method-include}{\code{Linne$include()}}
\item \href{#method-write}{\code{Linne$write()}}
\item \href{#method-print}{\code{Linne$print()}}
\item \href{#method-inject}{\code{Linne$inject()}}
\item \href{#method-clone}{\code{Linne$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-define"></a>}}
\if{latex}{\out{\hypertarget{method-define}{}}}
\subsection{Method \code{define()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$define(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Named variables to define.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define variables.
}

\subsection{Returns}{
Self: the \code{Linne} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Linne$new()$define(baseColor = "blue")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rule"></a>}}
\if{latex}{\out{\hypertarget{method-rule}{}}}
\subsection{Method \code{rule()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$rule(selector, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{selector}}{An object of class \code{selector} as returned by the \verb{sel_*} family of functions.}

\item{\code{...}}{Declarations: properties and their values. This accepts
camelcase, e.g.: \code{font-style} or \code{fontStyle}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Rule

Define a CSS rule.
}

\subsection{Returns}{
Self: the \code{Linne} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Linne$new()$rule(sel_id("myButton"), color = "blue", fontSize = 50)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-build"></a>}}
\if{latex}{\out{\hypertarget{method-build}{}}}
\subsection{Method \code{build()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$build()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Builds CSS

Builds the CSS from definitions and rules.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Linne$
 new()$
 define(primary_color = 'red')$
 rule(
   sel_id("myButton"), 
   color = primary_color, 
   fontSize = 50
 )$
 rule(
   sel_class("container"),
   backgroundColor = primary_color
 )$
 build()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_css"></a>}}
\if{latex}{\out{\hypertarget{method-get_css}{}}}
\subsection{Method \code{get_css()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$get_css(build = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{build}}{Whether to build the CSS with the \code{build} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Retrieve the CSS
}

\subsection{Returns}{
A string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Linne$new()$rule(sel_id("myId"), fontSize = 20)$get_css()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show_css"></a>}}
\if{latex}{\out{\hypertarget{method-show_css}{}}}
\subsection{Method \code{show_css()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$show_css(build = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{build}}{Whether to build the CSS with the \code{build} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Prints Generated CSS
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Linne$new()$rule(sel_id("myButton"), color = "blue")$show_css()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-import"></a>}}
\if{latex}{\out{\hypertarget{method-import}{}}}
\subsection{Method \code{import()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$import(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{URL to import.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Import

Import from a url or path.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Linne$new()$import('https://fonts.googleapis.com/css2?family=Roboto')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-include"></a>}}
\if{latex}{\out{\hypertarget{method-include}{}}}
\subsection{Method \code{include()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$include(build = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{build}}{Whether to build the CSS with the \code{build} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Include in Shiny

Includes the CSS in shiny, place the call to this method anywhere in the shiny UI.
}

\subsection{Returns}{
\link[htmltools:builder]{htmltools::tags}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# generate CSS
css <- Linne$
  new()$
  define(grey = '#c4c4c4')$
  rule(
    sel_id("myButton"), 
    backgroundColor = 'red', 
    fontSize = 20,
    color = grey
  )$
  rule(
    sel_class("aClass"),
    color = grey
  )

# include in an app
library(shiny)

ui <- fluidPage(
  css$include(),
  h1("Some text", class = "aClass"),
  actionButton("myButton", "Am I red?", class = "aClass")
)

server <- function(input, output){
  output$myPlot <- renderPlot(plot(cars))
}

if(interactive())
 shinyApp(ui, server)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write"></a>}}
\if{latex}{\out{\hypertarget{method-write}{}}}
\subsection{Method \code{write()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$write(path = "style.css", pretty = FALSE, build = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to file.}

\item{\code{pretty}}{Whether to keep tabs and newlines.}

\item{\code{build}}{Whether to build the CSS with the \code{build} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Save

Write the CSS to file.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if(interactive()) 
 Linne$new()$rule(sel_id("id"), fontStyle = "italic")$write("styles.css")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print

Prints information on the Linne object.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inject"></a>}}
\if{latex}{\out{\hypertarget{method-inject}{}}}
\subsection{Method \code{inject()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$inject(build = TRUE, session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{build}}{Whether to build the CSS with the \code{build} method.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Inject CSS

Dynamically inject CSS from the server of a shiny application.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(shiny)

ui <- fluidPage(
  useLinne(),
  actionButton("change", "Change me!")
)

server <- function(input, output){

  linne <- Linne$
    new()$
    rule(
      sel_id("change"),
      color = "white",
      backgroundColor = "black"
    )

  observeEvent(input$change, {
    linne$inject()
  })

}

if(interactive())
 shinyApp(ui, server)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Linne$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
