% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraction.R
\name{extract_function_examples}
\alias{extract_function_examples}
\title{Extract Examples from a Package Function}
\usage{
extract_function_examples(package_name, function_name)
}
\arguments{
\item{package_name}{A character string specifying the name of the package}

\item{function_name}{A character string specifying the name of the function}
}
\value{
A character string containing the cleaned examples code, or `NA`
  if no examples are found or an error occurs
}
\description{
This function extracts and cleans the examples section from a specific
function's documentation in an R package. It uses the `tools` package
to access the Rd database and extracts examples using `tools::Rd2ex()`.
The output is cleaned to remove metadata headers and formatting artifacts.
}
\examples{
\dontrun{
# Extract examples from ggplot2's geom_point function
examples <- extract_function_examples("ggplot2", "geom_point")
cat(examples)
}

}
