% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_forc_general.R
\name{conditional_forc_general}
\alias{conditional_forc_general}
\title{General model forecast conditioned on input forecasts}
\usage{
conditional_forc_general(
  model_function,
  prediction_function,
  data,
  time_vec,
  ...
)
}
\arguments{
\item{model_function}{Function that estimates a model using the \code{data} input.}

\item{prediction_function}{Function that generates model predictions using \code{model_function}
and \code{data} arguments. Note* that the \code{data} argument passed to the prediction_function
takes the form of a data.frame with a number of columns equal to the number of
input vintage forecasts passed by the user. The prediction_function needs to be able to take
this input format and generate a prediction based on it.}

\item{data}{Input data for estimating the model.}

\item{time_vec}{Vector of any class that represents time and is equal in length to
the length of \code{realized} and \code{data}.}

\item{...}{Set of forecasts of class Forecast, one forecast for each
parameter in the linear model.}
}
\value{
\code{\link{Forecast}} object that contains the out-of-sample
forecast.
}
\description{
\code{conditional_forc_general} takes a model function, a prediction function,
input data for estimating the model, and a vector of time data associated with the
model. The model is estimated once over the entire sample period and the model
parameters are then combined with the input forecasts to generate a forecast.
Returns a forecast conditional on forecasts of each parameter. Used to create a
forecast for the present period or replicate a forecast made at a specific period
in the past.
}
\examples{


# Estimation Data.
date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30", "2012-09-30", "2012-12-31",
                  "2013-03-31", "2013-06-30", "2013-09-30", "2013-12-31"))
y  <- c(1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0)
x1 <- c(8.22, 3.86, 4.27, 3.37, 5.88, 3.34, 2.92, 1.80, 3.30, 7.17, 3.22, 3.86,
    4.27, 3.37, 5.88, 3.34)
x2 <- c(4.03, 2.46, 2.04, 2.44, 6.09, 2.91, 1.68, 2.91, 3.87, 1.63, 4.03, 2.46, 
    2.04, 2.44, 6.09, 2.91)
dataLogit <- data.frame(date, y, x1, x2)

# Parameter Forecasts.
x1_forecastLogit <- Forecast(
   origin   = as.Date(c("2013-12-31", "2013-12-31", "2013-12-31", "2013-12-31")),
   future   = as.Date(c("2014-03-31", "2014-06-30", "2014-09-30", "2014-12-31")),
   forecast = c(2.11, 6.11, 6.75, 4.30),
   realized = NULL,
   h_ahead  = NULL
)

x2_forecastLogit <- Forecast(
   origin   = as.Date(c("2013-12-31", "2013-12-31", "2013-12-31", "2013-12-31")),
   future   = as.Date(c("2014-03-31", "2014-06-30", "2014-09-30", "2014-12-31")),
   forecast = c(1.98, 7.44, 7.86, 5.98),
   realized = NULL,
   h_ahead  = NULL
)

# Forecasting Function.
conditional_forc_general(
    model_function = function(data) {glm(y ~ x1 + x2, data = data, family = binomial)},
    prediction_function = function(model_function, data) {
        names(data) <- c("x1", "x2")
        as.vector(predict(model_function, data, type = "response"))
    }, 
    data = dataLogit,
    time_vec = dataLogit$date,
    x1_forecastLogit, x2_forecastLogit
) 

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
