% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmForc_subset.R
\name{subset_bytime}
\alias{subset_bytime}
\title{Subset a list of Forecast objects by origin or future values.}
\usage{
subset_bytime(forcs, values, slot)
}
\arguments{
\item{forcs}{List of Forecast objects.}

\item{values}{Single time object or a vector of time objects. The class of the values
must match the class of the origin and future values in the list of Forecast objects.}

\item{slot}{Character representing whether the list of Forecasts will be subset
by origin or future values. Must be either "origin" or "future".}
}
\value{
List of subsetted Forecast objects.
}
\description{
Function for subsetting all forecasts in a list of Forecast objects based
on origin or future values.
}
\examples{

forc1_1h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-05", "2011-03-10")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(4.27, 3.36, 4.78, 5.45, 5.12),
  realized = c(4.96, 4.17, 4.26, 4.99, 5.38),
  h_ahead = 1
)

forc2_1h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-22", "2011-03-27")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(4.01, 3.89, 3.31, 4.33, 4.61),
  realized = c(4.96, 4.17, 4.26, 4.99, 5.38),
  h_ahead = 1
)

forcs <- list(forc1_1h, forc2_1h)

subset_bytime(forcs, values = as.Date("2010-05-14"), slot = "origin")

subset_bytime(
   forcs, 
   values = as.Date(c("2010-09-30", "2010-12-31", "2011-03-31")), 
   slot = "future"
)

}
