% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_surrogate.R
\name{individual_surrogate_model}
\alias{individual_surrogate_model}
\title{LIME-like explanations based on Ceteris Paribus curves}
\usage{
individual_surrogate_model(
  x,
  new_observation,
  size,
  seed = NULL,
  kernel = identity_kernel,
  sampling = "uniform",
  ...
)
}
\arguments{
\item{x}{an explainer created with the function DALEX::explain().}

\item{new_observation}{an observation to be explained. Columns in should correspond to columns in the data argument to x.}

\item{size}{number of similar observation to be sampled.}

\item{seed}{If not NULL, seed will be set to this value for reproducibility.}

\item{kernel}{Kernel function which will be used to weight simulated observations.}

\item{sampling}{Parameter that controls sampling while creating new observations.}

\item{...}{Additional arguments that will be passed to ingredients::ceteris_paribus.}
}
\value{
data.frame of class local_surrogate_explainer
}
\description{
This function fits a LIME-type explanation of a single prediction.
Interpretable binary features that describe the local impact of features on
the prediction are created based on Ceteris Paribus Profiles.
Thend, a new dataset of similar observations is created and black box model
predictions (scores in case of classification) are calculated for this dataset
and LASSO regression model is fitted to them.
This way, explanations are simplified and include only the most important features.
More details about the methodology can be found in the vignettes.
}
\examples{
# Example based on apartments data from DALEX package.
library(DALEX)
library(randomForest)
library(localModel)
data('apartments')
mrf <- randomForest(m2.price ~., data = apartments, ntree = 50)
explainer <- explain(model = mrf,
                     data = apartments[, -1])
model_lok <- individual_surrogate_model(explainer, apartments[5, -1],
                                        size = 500, seed = 17)
model_lok
plot(model_lok)

}
