% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIA_functions.R
\name{base_GIA}
\alias{base_GIA}
\title{Estimate GIA according to the base model}
\usage{
base_GIA(model_params, dose_A, dose_B, fn_list = NULL)
}
\arguments{
\item{model_params}{named vector of parameters to be used in function.  Specifically, the named parameters must be "beta_A", "beta_B", "gamma_A", "gamma_B", "tau_1", and "tau_2".  See details for more info.}

\item{dose_A}{numeric vector of doses (e.g. mg/mL) of dose_A}

\item{dose_B}{numeric vector of doses (e.g. mg/mL) of dose_B}

\item{fn_list}{NULL}
}
\value{
estimated GIA for each combination of dose A and dose B
}
\description{
Estimate GIA according to the base model
}
\section{Details}{

The equation is given in full as follows.  The GIA (\%) is given a as a function of the model parameters and the doses \eqn{A_i} and \eqn{B_i}, respectively.  The doses scaled by the respective ED50s \eqn{\beta_A} and \eqn{\beta_B} are denoted by \eqn{A_i^*} and \eqn{B_i^*}, respectively.  The parameters \eqn{\gamma_A} and \eqn{\gamma_B} are shape parameters.  The parameters \eqn{\tau_1} and \eqn{\tau_2} are interaction parameters.  Finally, \eqn{\lambda_i} is a weighted combination of dose A and dose B.
\deqn{GIA_i = 100\%(1 - e^{-\psi_i})}
\deqn{\psi_i = \log(2)u_i^{v_i}}
\deqn{u_i = A^*_i + B_i^* + \tau_1  A^*_i B^*_i}
\deqn{v_i = \lambda_i \gamma_A + (1-\lambda_i) \gamma_B + \tau_1 \tau_2\lambda_i (1 - \lambda_i) \gamma_A \gamma_B}
\deqn{\lambda_i = \frac{A_i^*}{A_i^* + B_i^*}}
\deqn{A_i^* = A_i / \beta_A}
\deqn{B_i^* = B_i / \beta_B}
}

\examples{
model_params <- c("beta_A" = 1, "beta_B" = 2, "gamma_A" = .5,
"gamma_B" = .6,  "tau_1" = 1, "tau_2" = 0)
dose_A <- c(0, 1, 0)
dose_B <- c(0, 0, 1)
base_GIA(model_params, dose_A, dose_B)
}
