% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_isobologram}
\alias{plot_isobologram}
\title{Plot the estimated isobologram}
\usage{
plot_isobologram(
  est_list,
  dose_A = "Dose A",
  dose_B = "Dose B",
  GIA_fn = base_GIA,
  fn_list = NULL,
  title = "Isobologram Dose Combos",
  subtitle = "",
  base_size = 14
)
}
\arguments{
\item{est_list}{output from \code{estimate_params}}

\item{dose_A}{to pass to ggplot}

\item{dose_B}{to pass to ggplot}

\item{GIA_fn}{function to calculate GIA}

\item{fn_list}{additional arguments to pass to GIA fn}

\item{title}{to pass to ggplot}

\item{subtitle}{to pass to ggplot}

\item{base_size}{to pass to ggplot}
}
\value{
ggplot object
}
\description{
Plot the estimated isobologram
}
\examples{
df <- loewesadditivity::cyrpa_ripr
df$dose_A <- df$CyRPA
df$dose_B <- df$RIPR
data <- fortify_gia_data(df)
model_params <- c("beta_A" = .5, "beta_B" = .5,
                 "gamma_A" = .5, "gamma_B" = .5,
                 "tau_1" = 0, "tau_2" = 0)
n_boot <- 10
GIA_fn <- base_GIA
S_fn <- calc_S_base
fn_list <- NULL
alpha <- .05
verbose <- FALSE
out <- estimate_params(data = data,
init_params = model_params,
n_boot = n_boot,
GIA_fn = GIA_fn,
S_fn = S_fn,
fn_list = fn_list,
alpha = alpha,
verbose = verbose)
plot_curves(out, dose_A = "CyRPA",
dose_B = "RIPR")

}
