% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-text.R
\name{vector_text_matrix}
\alias{vector_text_matrix}
\title{Create a binary matrix of the rendered text}
\usage{
vector_text_matrix(
  text,
  font = c("gridfont_smooth", "gridfont", "arcade"),
  scale_coords = 1,
  scale_matrix = 1,
  dx = NULL,
  dy = NULL,
  missing = utf8ToInt("?")
)
}
\arguments{
\item{text}{Single text string. Can include carriage returns to split text 
over multiple lines.}

\item{font}{Name of vector font, or a vector 'lofi' font object.  Default: 'gridfont_smooth'.
Use \code{get_lofi_names('vector')} to retrieve a list of all valid
vector fonts included in this package.}

\item{scale_coords}{Scale factor for text rendering. Numeric value greater than zero.
Default: 1}

\item{scale_matrix}{Integer size scale factor. Default: 1.  Must be an integer value >= 1.
Scale up the matrix or raster result by this factor after rendering 
the coordinates.}

\item{dx}{Additional character spacing in the horizontal direction. Default: 0}

\item{dy}{Additional character spacing in the vertical direction i.e. between 
rows of text. Default: 0}

\item{missing}{Codepoint to use if glyph not found in font. 
Default: NULL means to use the default specified by the font internally.
Otherwise it will default to the codepoint for '?'}
}
\value{
Binary matrix rendering of the font
}
\description{
Create a binary matrix of the rendered text
}
\examples{
vector_text_matrix("Hi")
}
\seealso{
Other vector text functions: 
\code{\link{vector_text_coords}()},
\code{\link{vector_text_raster}()}
}
\concept{vector text functions}
