% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convexLogisticPCA.R
\name{convexLogisticPCA}
\alias{convexLogisticPCA}
\title{Convex Logistic Principal Component Analysis}
\usage{
convexLogisticPCA(x, k = 2, m = 4, quiet = TRUE, partial_decomp = FALSE,
  max_iters = 1000, conv_criteria = 1e-06, random_start = FALSE, start_H,
  mu, main_effects = TRUE, ss_factor = 4, weights, M)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{k}{number of principal components to return}

\item{m}{value to approximate the saturated model}

\item{quiet}{logical; whether the calculation should give feedback}

\item{partial_decomp}{logical; if \code{TRUE}, the function uses the rARPACK package
to quickly initialize \code{H} when \code{ncol(x)} is large and \code{k} is small}

\item{max_iters}{number of maximum iterations}

\item{conv_criteria}{convergence criteria. The difference between average deviance
in successive iterations}

\item{random_start}{logical; whether to randomly inititalize the parameters. If \code{FALSE},
function will use an eigen-decomposition as starting value}

\item{start_H}{starting value for the Fantope matrix}

\item{mu}{main effects vector. Only used if \code{main_effects = TRUE}}

\item{main_effects}{logical; whether to include main effects in the model}

\item{ss_factor}{step size multiplier. Amount by which to multiply the step size. Quadratic
convergence rate can be proven for \code{ss_factor = 1}, but I have found higher values
sometimes work better. The default is \code{ss_factor = 4}.
If it is not converging, try \code{ss_factor = 1}.}

\item{weights}{an optional matrix of the same size as the \code{x} with non-negative weights}

\item{M}{depricated. Use \code{m} instead}
}
\value{
An S3 object of class \code{clpca} which is a list with the
following components:
\item{mu}{the main effects}
\item{H}{a rank \code{k} Fantope matrix}
\item{U}{a \code{ceiling(k)}-dimentional orthonormal matrix with the loadings}
\item{PCs}{the princial component scores}
\item{m}{the parameter inputed}
\item{iters}{number of iterations required for convergence}
\item{loss_trace}{the trace of the average negative log likelihood using the Fantope matrix}
\item{proj_loss_trace}{the trace of the average negative log likelihood using the projection matrix}
\item{prop_deviance_expl}{the proportion of deviance explained by this model.
   If \code{main_effects = TRUE}, the null model is just the main effects, otherwise
   the null model estimates 0 for all natural parameters.}
}
\description{
Dimensionality reduction for binary data by extending Pearson's
PCA formulation to minimize Binomial deviance. The convex relaxation
to projection matrices, the Fantope, is used.
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run convex logistic PCA on it
clpca = convexLogisticPCA(mat, k = 1, m = 4)
}
\references{
Landgraf, A.J. & Lee, Y., 2015. Dimensionality reduction for binary data through 
the projection of natural parameters. arXiv preprint arXiv:1510.06112.
}

