% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRR.R
\name{printmRR}
\alias{printmRR}
\title{Print adjusted relative risk using multinomial logistic regression under binary or ordinal exposure variable.}
\usage{
printmRR(formula, basecov = 0, fixcov = NULL, data)
}
\arguments{
\item{formula}{a formula term that is passed into \code{multinom()} where response should be a factor having \code{K} different levels. Every term appearing in the formula should be well-defined as a column of \code{data}. Reference response should be specified as the first level.}

\item{basecov}{a baseline value of exposure variable. Defaults to \code{0}.}

\item{fixcov}{a data frame of fixed value for each of adjusted confounders. If there is no confounder other than the exposure variable of interest, \code{fixcov} = \code{NULL}; if \code{fixcov} is missing for existing covariates, they are all set to \code{0} (for numerical covariates) or to the first level (for factor covariates).}

\item{data}{a data frame containing response variable and all the terms used in \code{formula}.}
}
\value{
\item{\code{fit}}{an object of class \code{multinom}.}
\item{\code{RRR}}{(adjusted) relative risk ratio of \code{K} different responses compared to reference response under exposure at baseline (\code{basecov}) and \code{basecov + 1}.}
\item{\code{RR}}{(adjusted) relative risk of \code{K} different responses under exposure at baseline (\code{basecov}) and \code{basecov + 1}.}
\item{\code{delta.var}}{estimated variance of relative risk (\code{RR}) using Delta method.}
\item{\code{fix.cov}}{a data frame of fixed value for each of adjsuted confounders.}
}
\description{
Print adjusted relative risk using multinomial logistic regression under binary or ordinal exposure variable.
}
\examples{
n <- 500
set.seed(1234)
X <- rbinom(n, 1, 0.3)
W <- rbinom(n, 1, 0.3)
W[sample(1:n, n/3)] = 2
Y <- rbinom(n, 1, plogis(X - W))
dat <- as.data.frame(cbind(Y, X, W))
result <- printmRR(W ~ X + Y, basecov = 0, data = dat)


}
\author{
Youjin Lee
}
