% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KE_trajSCB.R
\name{KE_trajSCB}
\alias{KE_trajSCB}
\title{KE_trajSCB}
\usage{
KE_trajSCB(KE.fit.object,nboot=500,alpha=0.05)
}
\arguments{
\item{KE.fit.object}{An object whose class is KE (you can get it by letting ke = KE.fit())}

\item{nboot}{Number of bootstrap sample size to construct SCB}

\item{alpha}{Confidence level for bootstrap SCB of predicted response trajectory}
}
\value{
A list containing num.test elements where the num.test represents the number of testing subjects.
        Within each element, there is a list containing 3 elements:
\item{se}{A vector containing standard errors at each discrete measurement time}
\item{traj.upper}{A vector containing upper bound of the testing subject at each measurement time}
\item{traj.lower}{A vector containing lower bound of the testing subject at each measurement time}
}
\description{
Function used to derive simultaneous confidence band (SCB) for the predicted response trajectory
}
\examples{
\donttest{t_all = 1:50}
\donttest{T1=c(1,25);T2=c(26,50)}
\donttest{data = datagen(ntotal=350,ntest=50,t_all=t_all,t_split=25,seed=1)}
\donttest{train = data$train}
\donttest{test = data$test}
\donttest{ke.fit = KE_fit(train=train,test=test,T1=T1,T2=T2,bw_time=1,bw_subj = 0.2)}
\donttest{ketraj.toy = KE_trajSCB(KE.fit.object = ke.fit,
            nboot=10,alpha=0.05)}
}
\references{
\cite{Wang S, Kim S, Cho H, Chang W.
      Nonparametric predictive model for sparse and irregular longitudinal data. (2023+)}

\cite{Kim, S., Ryan Cho, H., & Kim, M. O. (2021).
Predictive generalized varying‐coefficient longitudinal model. Statistics in Medicine, 40(28), 6243-6259.}
}
\seealso{
\code{\link{KE_fit}}
}
