% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphutils.R
\name{completegraph}
\alias{completegraph}
\title{Create a complete graph or digraph with a set of nodes}
\usage{
completegraph(nodes, isDirected = FALSE)
}
\arguments{
\item{nodes}{a character vector with node names, each element defines a node
hence the elements need to be unique}

\item{isDirected}{a boolean scalar to indicate wheter the returned object is
a complete graph (undirected) or a complete digraph (directed).}
}
\value{
graph object of class loongraph
}
\description{
From Wikipedia: "a complete graph is a simple undirected graph
  in which every pair of distinct vertices is connected by a unique edge. A
  complete digraph is a directed graph in which every pair of distinct
  vertices is connected by a pair of unique edges (one in each direction
}
\details{
Note that this function masks the completegraph function of the
  graph package. Hence it is a good idead to specify the package namespace
  with ::, i.e. loon::completegraph and graph::completegraph.

For more information run: \code{l_help("learn_R_display_graph.html.html#graph-utilities")}
}
\examples{
g <- loon::completegraph(letters[1:5])
}
