% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_binCut.R
\name{l_binCut}
\alias{l_binCut}
\title{Get labels for each observation according to bin cuts in the histogram.}
\usage{
l_binCut(widget, labels, digits = 2, inactive)
}
\arguments{
\item{widget}{A loon histogram widget.}

\item{labels}{Labels to identify which bin observations are in.
By default, labels are constructed using "(a,b]" interval notation.
If \code{labels = FALSE}, simple integer codes given by the histogram's bin number are returned instead of a factor.
The \code{labels} can also be any vector of length equal to the number of bins; these will be used to
construct a vector identifying the bins.}

\item{digits}{The number of digits used in formatting the breaks for default labels.}

\item{inactive}{The value to use for inactive observations when labels is a vector.
Default depends on \code{labels}.}
}
\value{
A vector of bin identifiers having length equal to the total number of observations in the histogram.
The type of vector depends on the \code{labels} argument.
For default \code{labels = NULL}, a factor is returned, for \code{labels = FALSE}, a vector of bin numbers, and
for arbitrary vector \code{labels} a vector of bins labelled in order of \code{labels} will be returned.
Inactive cases appear in no bin and so are assigned the value of \code{active} when given.
The default \code{active} value also depends on \code{labels}:  when \code{labels = NULL}, the default \code{active} is \code{"(-Inf, Inf)"};
when \code{labels = FALSE}, the default \code{active} is  \code{-1}; and when \code{labels} is a vector of length equal
to the number of bins, the default \code{active} is \code{NA}.
The value of \code{active} denotes the bin name for the inactive cases.
}
\description{
\code{l_binCut} divides \code{l_hist} widget \code{x} into current histogram intervals and codes values
\code{x} according to which interval they fall (if active). It is modelled on \code{\link{cut}} in \code{base} package.
}
\examples{
if(interactive()) {
h <- l_hist(iris)
h["active"] <- iris$Species != "setosa"
binCut <- l_binCut(h)
h['color'] <- binCut
## number of bins
nBins <- length(l_getBinIds(h))
## ggplot color hue
gg_color_hue <- function(n) {
  hues <- seq(15, 375, length = n + 1)
  hcl(h = hues, l = 65, c = 100)[1:n]
}
h['color'] <- l_binCut(h, labels = gg_color_hue(nBins), inactive = "firebrick")
h["active"] <- TRUE
}

}
\seealso{
\code{\link{l_getBinData}}, \code{\link{l_getBinIds}}, \code{\link{l_breaks}}
}
