% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{df_fevd}
\alias{df_fevd}
\title{Fit EVD Parameters to Rows of a Data Frame of Annual Maxima}
\usage{
df_fevd(
  varbIN,
  cores = 1,
  ntries = 1,
  evd_mod_str = "fgumbel",
  nsloc = NULL,
  seed = NULL
)
}
\arguments{
\item{varbIN}{A numeric \code{data.frame} where each row is a vector of annual maxima values (e.g., one row per location or site).}

\item{cores}{An \code{integer} specifying the number of parallel cores to use for computation.}

\item{ntries}{The \code{integer} number of tries to fit the evd}

\item{evd_mod_str}{A \code{character} string specifying the EVD fitting function to use. Must be one of \code{"fgumbel"}, \code{"fgumbelx"}, or \code{"fgev"}.}

\item{nsloc}{Optional \code{data.frame} of covariates for non-stationary location modelling. Must have the same number of rows as \code{varbIN}.}

\item{seed}{Optional \code{integer} for reproducibility. If supplied, a random seed will be set before model fitting.}
}
\value{
A \code{data.frame} with one row per input time series, containing the fitted EVD parameters returned by \code{evd_params()}.
}
\description{
Fits an extreme value distribution (EVD) to each row of a \code{data.frame}, where each row represents a time series of annual maxima. Optionally includes non-stationary covariates in the location parameter. Parallel processing is used to improve efficiency.
}
\details{
Each row of \code{varbIN} is passed to \code{evd_params()}, optionally with a corresponding row of covariates from \code{nsloc}. Covariates are internally standardised if provided. The function constructs a blank parameter structure (\code{empty_evd_params}) to ensure consistent output structure, even if fitting fails.

Parallel computation is performed using \code{\link[parallel]{parLapply}}.
}
\examples{
set.seed(42)
df <- as.data.frame(matrix(evd::rgev(1000), nrow = 100))
results <- df_fevd(df, cores = 1, evd_mod_str = "fgumbel")

}
\seealso{
\code{\link{list_fevd}} to apply EVD fitting to a list of annual maxima,
\code{\link{evd_params}} for direct fitting to a single time series.
#'
}
