% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsprobust.R
\name{lsprobust}
\alias{lsprobust}
\alias{print.lsprobust}
\alias{summary.lsprobust}
\title{Partitioning-Based Least Squares Regression with Robust Inference.}
\usage{
lsprobust(y, x, eval = NULL, neval = NULL, method = "bs", m = NULL,
  m.bc = NULL, deriv = NULL, smooth = NULL, bsmooth = NULL,
  ktype = "uni", knot = NULL, nknot = NULL, same = TRUE,
  bknot = NULL, bnknot = NULL, J = NULL, bc = "bc3", proj = TRUE,
  kselect = "imse-dpi", vce = "hc2", level = 95, uni.method = NULL,
  uni.grid = NULL, uni.ngrid = 50, uni.out = FALSE, band = FALSE,
  B = 1000, subset = NULL, rotnorm = TRUE)

\method{print}{lsprobust}(x, ...)

\method{summary}{lsprobust}(object, ...)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Independent variable. A matrix or data frame.}

\item{eval}{Evaluation points. A matrix or data frame.}

\item{neval}{Number of quantile-spaced evaluating points.}

\item{method}{Type of basis used for expansion. Options are \code{"bs"} for B-splines,
\code{"wav"} for compactly supported wavelets (Cohen, Daubechies and Vial, 1993),
and \code{"pp"} for piecewise polynomials. Default is \code{method="bs"}.}

\item{m}{Order of basis used in the main regression. Default is \code{m=2}. For B-splines,
if \code{smooth} is specified but \code{m} is unspecified, default is \code{m=smooth+2}.}

\item{m.bc}{Order of basis used to estimate leading bias. Default is \code{m.bc=m+1}. For B-splines,
if \code{bsmooth} is specified but \code{m.bc} is unspecified, default is \code{m.bc=bsmooth+2}.}

\item{deriv}{Derivative order of the regression function to be estimated. A vector object of the same
length as \code{ncol(x)}. Default is \code{deriv=c(0,...,0)}.}

\item{smooth}{Smoothness of B-splines for point estimation. When \code{smooth=s}, B-splines have \code{s}-order
continuous derivatives. Default is \code{smooth=m-2}.}

\item{bsmooth}{Smoothness of B-splines for bias correction. Default is \code{bsmooth=m.bc-2}.}

\item{ktype}{Knot placement. Options are \code{"uni"} for evenly-spaced knots over the
support of \code{x} and \code{"qua"} for quantile-spaced knots. Default is \code{ktype="uni"}.}

\item{knot}{A list of numeric vectors giving the knot positions (including boundary knots) for each dimension
which are used in the main regression. The length of the list is equal to \code{ncol(x)}.
If not specified, it uses the number of knots either specified by users
or computed by the companion command \code{lspkselect} to generate the
corresponding knots according to the rule specified by \code{ktype}.}

\item{nknot}{A numeric vector of the same length as \code{ncol(x)}. Each element corresponds to
the number of \emph{inner} partitioning knots for each dimension used in the main regression.
If not specified, \code{nknot} is computed by the companion command \code{lspkselect}.}

\item{same}{If \code{TRUE}, the same knots are used for bias correction as that for the
main regression. Default is \code{same=TRUE}.}

\item{bknot}{A list of numeric vectors giving knot positions used for bias correction. If not
specified and \code{same=FALSE}, it uses the number of knots either specified by
users or computed by the companion command \code{lspkselect} to generate
knots according to the rule specified by \code{ktype}.}

\item{bnknot}{A numeric vector of the same length as \code{ncol(x)}. Each element corresponds
to the number of \emph{inner} partitioning knots for each dimension used for bias
correction. If not specified, \code{bnknot} is computed by the companion command \code{lspkselect}.}

\item{J}{A numeric vector containing resolution levels of father wavelets for each dimension.}

\item{bc}{Bias correction method. Options are \code{"bc1"} for higher-order-basis bias correction,
\code{"bc2"} for least squares bias correction, and \code{"bc3"} for plug-in bias correction.
Default are \code{"bc3"} for splines and piecewise polynomials and \code{"bc2"}
for wavelets.}

\item{proj}{If \code{TRUE}, projection of leading approximation error onto the lower-order approximation space
is included for bias correction (splines and piecewise polynomials only). Default is
\code{proj=TRUE}.}

\item{kselect}{Method for selecting the number of \emph{inner} knots used by \code{lspkselect}. Options
are \code{"imse-rot"} for ROT implementation of IMSE-optimal number of knots and
\code{"imse-dpi"} for second generation of DPI implementation of IMSE-optimal number
of knots. Default is \code{kselect="imse-dpi"}.}

\item{vce}{Procedure to compute the heteroskedasticity-consistent (HCk) variance-covariance matrix estimator with plug-in residuals. Options are
\itemize{
\item \code{"hc0"} for unweighted residuals (HC0).
\item \code{"hc1"} for HC1 weights.
\item \code{"hc2"} for HC2 weights. Default.
\item \code{"hc3"} for HC3 weights.
}}

\item{level}{Confidence level used for confidence intervals; default is \code{level=95}.}

\item{uni.method}{Method used to implement uniform inference. Options are \code{"pl"} for
a simulation-based plug-in procedure, \code{"wb"} for a wild bootstrap
procedure. If unspecified, neither procedure is
implemented. Default is \code{uni.method=NULL}.}

\item{uni.grid}{A matrix containing all grid points used to implement uniform inference. Each row
correponds to the coordinates of one grid point.}

\item{uni.ngrid}{A numeric vector of the same length as \code{ncol(x)}. Each element corresponds to
the number of grid points for each dimension used to implement uniform inference.
Default is \code{uni.ngrid=50}.}

\item{uni.out}{If \code{TRUE}, the quantities used to implement uniform inference is outputted. Default is
\code{uni.out=FALSE}.}

\item{band}{If \code{TRUE}, the critical value for constructing confidence band is calculated. Default
is \code{band=FALSE}. If \code{band=TRUE} with \code{uni.method} unspecified,
default is \code{uni.method="pl"}.}

\item{B}{Number of simulated samples used to obtain the critical value for confidence bands.
Default is \code{B=1000}.}

\item{subset}{Optional rule specifying a subset of observations to be used.}

\item{rotnorm}{If \code{TRUE}, ROT selection is adjusted using normal densities.}

\item{...}{further arguments}

\item{object}{class \code{lsprobust} objects.}
}
\value{
\item{\code{Estimate}}{ A matrix containing eval (grid points), N (effective sample sizes),
                            tau.cl (point estimates with a basis of order \code{m}), tau.bc (bias corrected point
                            estimates with a basis of order \code{m.bc}), se.cl (standard error corresponding
                            to tau.cl), and se.rb (robust standard error).}
       \item{\code{k.num}}{ A matrix containing the number of inner partitioning knots used in the main
                            regression and bias correction for each covariate.}
       \item{\code{knot}}{ A list of knots for point estimation.}
       \item{\code{bknot}}{ A list of knots for bias correction.}
       \item{\code{sup.cval}}{ Critical value for constructing confidence band.}
       \item{\code{uni.output}}{ A list containing quantities used to implement uniform inference.}
       \item{\code{opt}}{ A list containing options passed to the function.}
}
\description{
\code{lsprobust} implements partitioning-based least squares point estimators for the regression function and its derivatives. It also provides robust bias-corrected (pointwise and uniform) inference, including simulation-based confidence bands. Three series methods are supported: B-splines, compact supported wavelets, and piecewise polynomials.
            See \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Cattaneo and Farrell (2013)} and \href{https://arxiv.org/abs/1804.04916}{Cattaneo, Farrell and Feng (2020a)} for complete details.

            Companion commands: \code{\link{lspkselect}} for data-driven IMSE-optimal selection of the number of knots on rectangular partitions; \code{\link{lsprobust.plot}} for plotting results; \code{\link{lsplincom}} for multiple sample estimation and inference.

            A detailed introduction to this command is given in \href{https://arxiv.org/abs/1906.00202}{Cattaneo, Farrell and Feng (2020b)}.

            For more details, and related Stata and R packages useful for empirical analysis,
            visit \url{https://sites.google.com/site/nppackages/}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(lsprobust)}: \code{print} method for class "\code{lsprobust}"

\item \code{summary(lsprobust)}: \code{summary} method for class "\code{lsprobust}"

}}
\examples{
x   <- data.frame(runif(500), runif(500))
y   <- sin(4*x[,1])+cos(x[,2])+rnorm(500)
est <- lsprobust(y, x)
summary(est)

}
\references{
Cattaneo, M. D., and M. H. Farrell (2013): \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Optimal convergence rates, Bahadur representation, and asymptotic normality of partitioning estimators}. Journal of Econometrics 174(2): 127-143.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2020a): \href{https://arxiv.org/abs/1804.04916}{Large Sample Properties of Partitioning-Based Series Estimators}. Annals of Statistics, 48(3): 1718-1741, 2020.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2020b): \href{https://arxiv.org/abs/1906.00202}{lspartition: Partitioning-Based Least Squares Regression}. R Journal, 12(1): 172-187, 2020.

Cohen, A., I. Daubechies, and P.Vial (1993): Wavelets on the Interval and Fast Wavelet Transforms. Applied and Computational Harmonic Analysis 1(1): 54-81.
}
\seealso{
\code{\link{lspkselect}}, \code{\link{lsprobust.plot}}, \code{\link{lsplincom}}
}
\author{
Matias D. Cattaneo, Princeton University, Princeton, NJ. \email{cattaneo@princeton.edu}.

Max H. Farrell, University of California, Santa Barbara, CA. \email{maxhfarrell@ucsb.edu}.

Yingjie Feng (maintainer), Tsinghua University, Beijing, China. \email{fengyingjiepku@gmail.com}.
}
