% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkbo_triangle.R
\name{mkbo_triangle}
\alias{mkbo_triangle}
\title{Calculates Triangle}
\usage{
mkbo_triangle(
  mkbo_output,
  term = NULL,
  term.cat = NULL,
  components = c("E"),
  percentage = TRUE,
  absolute_gaps = TRUE
)
}
\arguments{
\item{mkbo_output}{placeholder text}

\item{term}{Specify the model term for which the mKBO results should be presented. Can be a vector of terms to present the summed results for those terms. Should be specified in quotation marks.}

\item{term.cat}{Specify a factor variable for which to sum the mKBO results across categories. Should be specified in quotation marks.}

\item{components}{Specify+he decomposition components to be included in the calculation. Can be any combination of c("E", "C", "I"), or "R".}

\item{percentage}{Specify to express the changes in gap as percentage (default) or in absolute differences (expressed in unites of the dependent variables).}

\item{absolute_gaps}{If TRUE, the changes in gaps are expressed in absolute terms even when signs change.}
}
\value{
An object of class \code{tibble},  containing absolute or relative group-differences explained by the variables specified in  \code{mKBO}.
}
\description{
This function calculates all group-differences
}
\examples{
mkbo_output <- mkbo("PERNP ~ BACHELOR", group = "RACE", data=pums_subset)
mkbo_triangle(mkbo_output, term="BACHELORTRUE")
}
