% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_provider.R
\name{get_provider}
\alias{get_provider}
\title{Determine provider from model name}
\usage{
get_provider(model)
}
\arguments{
\item{model}{Character string specifying the model name (e.g., "gpt-5.2", "claude-sonnet-4.5").}
}
\value{
Character string of the provider name (e.g., "openai", "anthropic").
}
\description{
This function determines the appropriate provider (e.g., OpenAI, Anthropic, Google, OpenRouter) based on the model name.
Uses prefix-based matching for efficient and maintainable provider detection.
New models following existing naming conventions are automatically supported.
}
\details{
Supported providers and model prefixes:
\itemize{
\item OpenAI: gpt-\emph{, o1}, o3*, o4*, chatgpt-\emph{, codex-} (e.g., 'gpt-5.2', 'o3-pro', 'o4-mini')
\item Anthropic: claude-* (e.g., 'claude-opus-4.6', 'claude-sonnet-4.5')
\item DeepSeek: deepseek-* (e.g., 'deepseek-chat', 'deepseek-r1')
\item Google: gemini-* (e.g., 'gemini-3-pro', 'gemini-2.5-flash')
\item Qwen: qwen*, qwq-* (e.g., 'qwen3-max', 'qwq-32b')
\item Stepfun: step-* (e.g., 'step-2-mini', 'step-2-16k')
\item Zhipu: glm-\emph{, chatglm} (e.g., 'glm-4.7', 'glm-4-plus')
\item MiniMax: minimax-* (e.g., 'minimax-m2.1', 'minimax-m1')
\item Grok: grok-* (e.g., 'grok-4', 'grok-4-heavy')
\item OpenRouter: Any model with '/' in the name (e.g., 'openai/gpt-5.2', 'anthropic/claude-sonnet-4.5')
}
}
