% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{generate}
\alias{generate}
\title{Create a new variable}
\usage{
generate(data, var, expr = NULL)
}
\arguments{
\item{data}{data.frame}

\item{var}{name for the new variable}

\item{expr}{a constant value, name of an existing variable or
an expression for simple arithmetic or logical operations:}
}
\value{
data.frame with the new variable
}
\description{
\code{generate()} creates a new variable either by
deriving from existing variables or with a constant value.
}
\details{
The values of the variable are specified by \code{expr}.

\strong{Label}

The newly created variable is automatically labeled with
the expression specified.
}
\examples{

## generate variable with a constant value
generate(mtcars, new_var, NA)
generate(mtcars, new_var, 99)

## generate variable from an existing variable
generate(mtcars, new_var, mpg)

## generate variable with arithmetic operations
generate(iris, Length, Sepal.Length + Petal.Length)

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
