% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{logit}
\alias{logit}
\title{Logistic Regression Model}
\usage{
logit(model, or = TRUE, digits = 5)
}
\arguments{
\item{model}{glm or lm model}

\item{or}{\code{TRUE}reports odds ratios instead of coefficients}

\item{digits}{specify rounding of numbers. See \code{\link{round}}.}
}
\value{
a list containing
\enumerate{
\item \code{info} - info and error tables
\item \code{reg} - regression table
\item \code{model} - raw model output from \code{lm()}
\item \code{fit} - formula for fitting the model
\item \code{lbl} - variable labels for further processing in \code{summary}.
}
}
\description{
\code{logit()} produces summary of the model with
coefficients or odds ratios (\code{OR}) and 95\% Confident Intervals.
}
\details{
\code{logit()} is based on \code{\link{glm}} with \code{binomial} family.
All statistics presented in the function's output are derivatives of
\code{\link{glm}},
except AIC value which is obtained from \code{\link{AIC}}.

\strong{Outputs}

Outputs can be divided into three parts.
\enumerate{
\item \verb{Info of the model}:
Here provides number of observations (Obs.), chi value from Likelihood Ratio
test (LR chi2) and its degree of freedom, p-value from LR test,
Pseudo R Squared, log likelihood and AIC values.
\item \verb{Regression Output}:
Coefficients from summary of model are tabulated here along with 95\\%
confidence interval.
}
}
\examples{

mylogit <- glm(case ~ education + age + parity, family = binomial,
           data = infert)
logit(mylogit)

\dontrun{
## Example from UCLA website:
## LOGIT REGRESSION | R DATA ANALYSIS EXAMPLES
## https://stats.idre.ucla.edu/r/dae/logit-regression/

mydata <- read.csv("https://stats.idre.ucla.edu/stat/data/binary.csv")
mydata <- replace(mydata, rank, factor(rank))
mydata <- label(mydata, gre = "GRE", gpa = "GPA score", rank = "Ranking")
mylogit <- glm(admit ~ gre + gpa + rank, data = mydata, family = "binomial")

## Showing Odds Ratios
logit(mylogit)

## Showing coefficients
logit(mylogit, or = FALSE)
}

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
