% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routing_functions.R
\name{updateGrade}
\alias{updateGrade}
\title{Update the grade slot of an examinee object}
\usage{
updateGrade(
  examinee_object,
  assessment_structure,
  module_position,
  cut_scores,
  transition_policy = "CI",
  transition_CI_alpha,
  transition_percentile_lower,
  transition_percentile_upper,
  item_pool
)
}
\arguments{
\item{examinee_object}{an \code{\linkS4class{examinee}} object.}

\item{assessment_structure}{an \code{\linkS4class{assessment_structure}} object.}

\item{module_position}{the current module position, ranging from \code{1} to \code{6}.}

\item{cut_scores}{a named list containing cut scores to be used in each grade. Each element must be named in the form \code{G?}, where \code{?} is a number.}

\item{transition_policy}{\itemize{
\item{\code{CI}} uses the confidence interval to perform routing.
\item{\code{pool_difficulty_percentile}} uses item difficulty percentiles of all items in the \code{item_pool} argument to perform routing.
\item{\code{pool_difficulty_percentile_exclude_administered}} uses item difficulty percentiles of all items in the \code{item_pool} argument to perform routing, excluding all previous items administered to the examinee.
\item{\code{on_grade}} does not permit any transition.
\item{} (default = \code{CI})
}}

\item{transition_CI_alpha}{the alpha level used when \code{transition_policy == "CI"}.}

\item{transition_percentile_lower}{the percentile value (between 0 and 1) used for the lower routing in percentile-based transition policies.}

\item{transition_percentile_upper}{the percentile value (between 0 and 1) used for the upper routing in percentile-based transition policies.}

\item{item_pool}{the \code{\link[TestDesign:item_pool-class]{item_pool}} object to determine difficulty range in percentile-based transition policies.}
}
\value{
an \code{\linkS4class{examinee}} object with its \code{current_grade} slot updated.
}
\description{
\code{\link{updateGrade}} is a function for determining the grade an examinee is routed to.
}
\details{
Currently the routing rules are hard-coded in the function. See the vignette for a description of routing rules.
}
