% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-dr.r
\name{mable.dr}
\alias{mable.dr}
\title{MABLE in Desnity Ratio Model}
\usage{
mable.dr(
  x,
  y,
  M,
  regr,
  ...,
  interval = c(0, 1),
  alpha = NULL,
  vb = 0,
  baseline = NULL,
  controls = mable.ctrl(),
  progress = TRUE,
  message = FALSE
)
}
\arguments{
\item{x, y}{original two sample raw data, \code{x}:"Control", \code{y}: "Case".}

\item{M}{a positive integer or a vector \code{(m0, m1)}.}

\item{regr}{regressor vector function \eqn{r(x)=(1,r_1(x),...,r_d(x))} 
which returns n x (d+1) matrix, n=length(x)}

\item{...}{additional arguments to be passed to regr}

\item{interval}{a vector \code{(a,b)} containing the endpoints of 
supporting/truncation interval of x and y.}

\item{alpha}{initial regression coefficient, missing value is imputed by 
logistic regression}

\item{vb}{code for vanishing boundary constraints, -1: f0(a)=0 only, 
1: f0(b)=0 only, 2: both, 0: none (default).}

\item{baseline}{the working baseline, "Control" or "Case", if \code{NULL}
it is chosen to the one with smaller estimated lower bound for model degree.}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion for EM and Newton iterations. Default is 
\code{\link{mable.ctrl}}. See Details.}

\item{progress}{logical: should a text progressbar be displayed}

\item{message}{logical: should warning messages be displayed}
}
\value{
A list with components
\itemize{
  \item \code{m} the given or a selected degree by method of change-point
  \item \code{p} the estimated vector of mixture proportions \eqn{p = (p_0, \ldots, p_m)}
      with the given or selected degree \code{m}
  \item \code{alpha} the estimated regression coefficients
  \item \code{mloglik}  the maximum log-likelihood at degree \code{m}
  \item \code{interval} support/truncation interval \code{(a,b)}
  \item \code{baseline} ="control" if \eqn{f_0} is used as baseline, 
    or ="case" if \eqn{f_1} is used as baseline.
  \item \code{M} the vector \code{(m0, m1)}, where \code{m1}, if greater than \code{m0}, is the
     largest candidate when the search stoped
  \item \code{lk} log-likelihoods evaluated at \eqn{m \in \{m_0, \ldots, m_1\}}
  \item \code{lr} likelihood ratios for change-points evaluated at \eqn{m \in \{m_0+1, \ldots, m_1\}}
  \item \code{pval} the p-values of the change-point tests for choosing optimal model degree
  \item \code{chpts} the change-points chosen with the given candidate model degrees
}
}
\description{
Maximum approximate Bernstein/Beta likelihood estimation in a
  density ratio model based on two-sample raw data.
}
\details{
Suppose that \code{x} ("control") and \code{y} ("case") are independent  
samples from f0 and f1 which  samples
satisfy f1(x)=f0(x)exp[alpha0+alpha'r(x)] with r(x)=(r1(x),...,r_d(x)). Maximum 
approximate Bernstein/Beta likelihood estimates of (alpha0,alpha), f0 and f1 
are calculated. If support is (a,b) then replace r(x) by r[a+(b-a)x].
For a fixed \code{m}, using the Bernstein polynomial model for baseline \eqn{f_0},
MABLEs of \eqn{f_0} and parameters alpha can be estimated by EM algorithm and Newton  
iteration. If estimated lower bound \eqn{m_b} for \code{m} based on \code{y}
is smaller that that based on \code{x}, then switch \code{x} and \code{y} and
\eqn{f_1} is used as baseline. If \code{M=m} or \code{m0=m1=m}, then \code{m} is a 
preselected degree. If \code{m0<m1} it specifies the set of consective  
candidate model degrees \code{m0:m1} for searching an optimal degree by 
the change-point method, where \code{m1-m0>3}.
}
\examples{
\donttest{
# Hosmer and Lemeshow (1989): 
# ages and the status of coronary disease (CHD) of 100 subjects 
x<-c(20, 23, 24, 25, 26, 26, 28, 28, 29, 30, 30, 30, 30, 30, 32,
32, 33, 33, 34, 34, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 39,
40, 41, 41, 42, 42, 42, 43, 43, 44, 44, 45, 46, 47, 47, 48, 49,
49, 50, 51, 52, 55, 57, 57, 58, 60, 64)
y<-c(25, 30, 34, 36, 37, 39, 40, 42, 43, 44, 44, 45, 46, 47, 48,
48, 49, 50, 52, 53, 53, 54, 55, 55, 56, 56, 56, 57, 57, 57, 57,
58, 58, 59, 59, 60, 61, 62, 62, 63, 64, 65, 69)
regr<-function(x) cbind(1,x)
chd.mable<-mable.dr(x, y, M=c(1, 15), regr, interval = c(20, 70))
chd.mable
}
}
\references{
Guan, Z., Maximum Approximate Bernstein Likelihood Estimation of 
  Densities in a Two-sample Semiparametric Model
}
\author{
Zhong Guan <zguan@iu.edu>
}
