% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAC.R
\name{MAC}
\alias{MAC}
\title{Mac and LogP measure}
\usage{
MAC(models, data, B, alpha, method = "bic", delta = 1e-04, eps = 1e-06)
}
\arguments{
\item{models}{A list with one entry for each model. Each entry is an
integer vector that specifies the columns of matrix \code{data$x} to be used
as a regressor in that model. An intercept will be fitted automatically.}

\item{data}{a list including
\describe{
\item{x}{covariates matrix, of dimension nobs and nvars;each row is an observation vector.}
\item{y}{response variable.}
}}

\item{B}{number of bootstrap replicates to perform; Default value is 200.}

\item{alpha}{a vector of significance levels. The confidence levels of the model confidence sets
are 1-\code{alpha}. Default value is 0.05.}

\item{method}{Information criterion. Users can choose from \code{"bic"}, \code{"aic"}.
Default value is \code{"bic"}.}

\item{delta}{A small positive number added inside of LogP when the bootstrap
probability of selected model is 1. Default value is \code{1e-4}.}

\item{eps}{toterance level in choosing models with total bootstrap probabilities
at least \code{1-alpha}. Default value is \code{1e-6}.}
}
\value{
Returns an object of class “MAC”. An object of
class “MAC” is a list containing at least the following components:
\item{hat_M}{numeric index of selected model.}
\item{con_sets}{a list with with one entry for a \code{1-alpha} model confidence set.
Each entry is an integer vector that specifies the models selected in this set. The model
indexes used in \code{con_sets} are their orders in \code{models}.}
\item{length_con}{lengths of confidence sets.}
\item{order}{Model indexes with increasing information scores based on original data.}
\item{probs_inorder}{Bootstrap probabilities for the models in \code{order}.}
\item{beta_ls}{a list with one entry for each model. Each entry is a vector
of estimated coefficients based on original data for that model.}
\item{hat_prob}{the Bootstrap probability for single selected model.}
\item{hat_logp}{the LogP measure.}
}
\description{
This function allows you to obtain a model confidence set using Mac procedure and the LogP uncertainty measure
for a selection method based on an information criterion.
}
\examples{
set.seed(0)
n= 50
B= 100
p= 5
x = matrix(rnorm(n*p, mean=0, sd=1), n, p)
true_b = c(1:3, rep(0,p-3))
y = x\%*\% true_b+rnorm(n)
alpha=c(0.1,0.05,0.01)
data=list(x=x,y=y)
models=Models_gen(1:p)
result=MAC(models, data, B, alpha)
}
\references{
Liu, X., Li, Y. & Jiang, J.(2020). Simple measures of uncertainty for model selection.
\emph{TEST}, 1-20.
}
\seealso{
\code{\link{plot_MAC}}
}
\keyword{LogP}
\keyword{Mac}
