% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maicPCA.R
\name{maicPCA}
\alias{maicPCA}
\title{Checks whether AD is outside IPD in PC coordinates}
\usage{
maicPCA(ipd, ad)
}
\arguments{
\item{ipd}{a dataframe with n row and p column, where n is number of subjects in IPD set and p is the number of variables used in matching.}

\item{ad}{a dataframe with 1 row and p column. The matching variables should be in the same order as that in \code{ipd}. The function does not check this.}
}
\value{
Prints a message whether AD is inside or outside IPD PC coordinates. Also returns a ggplot object to be plotted.
\item{pc.dplot }{dot-plot of AD and IPD both in IPD's PC coordinates}
\item{pca.check }{0 = AD within the ranges of IPD's PC coordinates; 2 = otherwise}
}
\description{
Checks whether AD is outside IPD in principal component (PC) coordinates
}
\details{
When AD is within the IPD PC ranges, AD can still be outside the IPD convex hull in the original scale. On the other hand, if AD is outside the IPD PC ranges, in the original scale AD is for sure outside the IPD convex hull.
}
\examples{
\dontrun{
## eAD[1,] is the scenario A in the reference paper,
## i.e. when AD is perfectly within IPD
a1 <- maicPCA(eIPD, eAD[1,2:3])
a1 ## the dot plots of PC's for IPD and AD

## eAD[3,] is the scenario C in the reference paper,
## i.e. when AD is outside IPD
a3 <- maicPCA(eIPD, eAD[3,2:3])
a3 ## the dot plots of PC's for IPD and AD
}
}
\references{
Glimm & Yau (2021). "Geometric approaches to assessing the numerical feasibility for conducting matching-adjusted indirect comparisons", Pharmaceutical Statistics, 21(5):974-987. doi:10.1002/pst.2210.
}
