% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_by_depto.R
\name{sp_by_depto}
\alias{sp_by_depto}
\title{Mammal occurrence by departamento}
\usage{
sp_by_depto(states, type = c("any", "only", "all"), taxa = NULL)
}
\arguments{
\item{states}{a character vector with one or more departamento names}

\item{type}{type of matching to be used. \code{any} will return the mammal species that
occur in any of the passed \code{states}. \code{only} matches mammal species that
occur only in all provided (no more, no less) \code{states} and \code{all} matches
mammal species that occur at least in all \code{states} passed. See examples.}

\item{taxa}{optional character vector to match against the departamentos. Use the order name}
}
\value{
a data frame
}
\description{
Find the mammal species that occur in a given departamento of Colombia
}
\examples{

library (mammalcol)

occ.any <- sp_by_depto(c("Arauca", "Norte de Santander"), type = "any")
occ.only <- sp_by_depto(c("Norte de Santander"), type = "only")
occ.all <- sp_by_depto(c("Arauca", "Norte de Santander"), type = "all")
occ.taxa <- sp_by_depto(c("Arauca", "Norte de Santander"), type = "all", taxa = "Chiroptera")

head(occ.any)
head(occ.only)
head(occ.all)
head(occ.taxa)


}
