% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{norm.Euclidean}
\alias{norm.Euclidean}
\alias{norm}
\alias{norm.default}
\alias{norm.L2}
\alias{norm.HS}
\alias{norm.Dens}
\alias{norm.SO}
\alias{norm.LogEu}
\alias{norm.AffInv}
\alias{norm.Sphere}
\title{Norm on the tangent space induced by the Riemannian metric}
\usage{
\method{norm}{Euclidean}(mfd, p, U)

norm(mfd, p, U)

\method{norm}{default}(mfd, p = NULL, U)

\method{norm}{L2}(mfd, p, U)

\method{norm}{HS}(mfd, p, U)

\method{norm}{Dens}(mfd, p, U)

\method{norm}{SO}(mfd, p, U)

\method{norm}{LogEu}(mfd, p, U)

\method{norm}{AffInv}(mfd, p, U)

\method{norm}{Sphere}(mfd, p, U)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{p, U}{Matrices with n columns. p stands for the base point(s) and U the tangent vector(s). The norm of each column in U is calculated w.r.t. the corresponding column in p.}
}
\value{
A vector with n entries containing the norms of the tangent vectors
}
\description{
Norm on the tangent space induced by the Riemannian metric
}
\section{Methods (by class)}{
\itemize{
\item \code{norm(Euclidean)}: Method

\item \code{norm(default)}: Method

\item \code{norm(L2)}: Method

\item \code{norm(HS)}: Method

\item \code{norm(Dens)}: Method

\item \code{norm(SO)}: Method

\item \code{norm(LogEu)}: Method

\item \code{norm(AffInv)}: Method

\item \code{norm(Sphere)}: Method

}}
