% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_fill.R
\name{add_fill_layer}
\alias{add_fill_layer}
\title{Add a fill layer to the map}
\usage{
add_fill_layer(map, source = NULL, filter = NULL,
  fill_antialias = TRUE, fill_color = NULL, fill_opacity = NULL,
  fill_outline_color = NULL, fill_pattern = NULL,
  fill_sort_key = NULL, fill_translate = NULL,
  fill_translate_anchor = NULL, visibility = TRUE, popup = NULL,
  id = "fill-layer")
}
\arguments{
\item{map}{A \link{mapboxer} object.}

\item{source}{A Mapbox source. Uses the source from the \link{mapboxer} object if no source is supplied.}

\item{filter}{A filter expression that is applied to the \code{source}.}

\item{fill_antialias}{(paint) Whether or not the fill should be antialiased.}

\item{fill_color}{(paint) The color of the filled part of this layer.
This color can be specified as rgba with an alpha component and
the color's opacity will not affect the opacity of the 1px stroke, if it is used.}

\item{fill_opacity}{(paint) The opacity of the entire fill layer.
In contrast to the \code{fill_color}, this value will also affect the 1px stroke around the fill,
if the stroke is used.}

\item{fill_outline_color}{(paint) The outline color of the fill.
Matches the value of \code{fill_color} if unspecified.}

\item{fill_pattern}{(paint) Name of image in sprite to use for drawing image fills.}

\item{fill_sort_key}{(layout) Sorts features in ascending order based on this value.
Features with a higher sort key will appear above features with a lower sort key.}

\item{fill_translate}{(paint) The geometry's offset.
Values are [x, y] where negatives indicate left and up, respectively.}

\item{fill_translate_anchor}{(paint) Controls the frame of reference for \code{fill_translate}.
One of "map", "viewport".}

\item{visibility}{(layout) Whether the layer should be displayed.}

\item{popup}{A \href{https://github.com/janl/mustache.js}{mustache} template
in which the tags refer to the properties of the layer's data object.}

\item{id}{The unique id of the layer.}
}
\description{
Add a fill layer to the map
}
\examples{
 map <- as_mapbox_source(geojsonsf::geo_melbourne) \%>\%
  mapboxer() \%>\%
  set_view_state(
    lng =  144.9624,
    lat = -37.8105,
    zoom = 10,
    pitch = 35
  ) \%>\%
  add_fill_layer(
    fill_color = c("get", "fillColor"),
    fill_opacity = 0.6,
    popup = "Area: {{AREASQKM}} km<sup>2</sup>",
    # AREASQKM > 5
    filter = list(">", c("get", "AREASQKM"), 5)
  )

if (interactive()) map
}
\seealso{
\url{https://docs.mapbox.com/mapbox-gl-js/style-spec/layers/#fill}
}
