% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sources.R
\name{as_mapbox_source}
\alias{as_mapbox_source}
\alias{as_mapbox_source.json}
\alias{as_mapbox_source.data.frame}
\alias{as_mapbox_source.sf}
\title{Convert a data object to a Mapbox GeoJSON source}
\usage{
as_mapbox_source(data, ...)

\method{as_mapbox_source}{json}(data, ...)

\method{as_mapbox_source}{data.frame}(data, lng = "lng", lat = "lat",
  ...)

\method{as_mapbox_source}{sf}(data, ...)
}
\arguments{
\item{data}{A data frame that contains longitudes and latitudes in separate columns
or an \code{sf}-object.}

\item{...}{The properties of the source.
See \url{https://docs.mapbox.com/mapbox-gl-js/style-spec/sources} for available options
for the given source type.}

\item{lng}{The name of the column containing the longitudes.}

\item{lat}{The name of the column containing the latitudes.}
}
\description{
Convert a data object to a Mapbox GeoJSON source
}
