% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_update.R
\name{set_data}
\alias{set_data}
\alias{set_data.character}
\alias{set_data.json}
\alias{set_data.data.frame}
\alias{set_data.sf}
\title{Update the data of a Mapbox source}
\usage{
set_data(map, data, source_id = NULL, ...)

\method{set_data}{character}(map, data, source_id = NULL, ...)

\method{set_data}{json}(map, data, source_id = NULL, ...)

\method{set_data}{data.frame}(map, data, source_id = NULL, lng = "lng",
  lat = "lat", ...)

\method{set_data}{sf}(map, data, source_id, ...)
}
\arguments{
\item{map}{A \link{mapboxer_proxy} object.}

\item{data}{A \code{GeoJSON} object, an url pointing to an external \code{GeoJSON} document,
a data frame that contains longitudes and latitudes in separate columns or an sf-object.}

\item{source_id}{The ID of the source whose data should be updated.}

\item{...}{unused}

\item{lng}{The name of the column containing the longitudes.}

\item{lat}{The name of the column containing the latitudes.}
}
\description{
Update the data of a Mapbox source
}
\seealso{
\itemize{
  \item \link[geojsonsf]{df_geojson}
  \item \link[geojsonsf]{sf_geojson}
}
}
