% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_india.R
\name{plot_india}
\alias{plot_india}
\title{Conveniently plot basic India map}
\usage{
plot_india(
  regions = c("states", "state", "districts", "district"),
  include = c(),
  exclude = c(),
  data = data.frame(),
  values = "values",
  theme = theme_map(),
  labels = FALSE,
  label_color = "black",
  label_size = 4,
  ...
)
}
\arguments{
\item{regions}{The region breakdown for the map, can be one of
(\code{"states"}, \code{"state"}, \code{"districts"}, \code{"district"}).
The default is \code{"states"}.}

\item{include}{The regions to include in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or code.
For districts, the district codes must be provided as there can be multiple districts with the
same name. If states are provided in the districts map, only districts in the included states
will be returned.}

\item{exclude}{The regions to exclude in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or code.
For districts, the district codes must be provided as there can be multiple districts with the
same name. The regions listed in the \code{include} parameter are applied first and the
\code{exclude} regions are then removed from the resulting map. Any excluded regions
not present in the included regions will be ignored.}

\item{data}{A data frame containing values to plot on the map. This
parameter should be a data frame consisting of two columns,
a code (2 characters for state, 3 characters for district)
and the value that should be associated with that region. The
columns of \code{data} \emph{must} be \code{code} or \code{state} and
the value of the `values` parameter.}

\item{values}{The name of the column that contains the values to be associated
with a given region. The default is \code{"value"}.}

\item{theme}{The theme that should be used for plotting the map. The default
is \code{theme_map} from \href{https://github.com/jrnold/ggthemes}{ggthemes}.}

\item{labels}{Whether or not to display labels on the map. Labels are not displayed
by default.}

\item{label_color}{The color of the labels to display. Corresponds to the \code{color}
option in the [ggplot2::aes()] mapping. The default is \code{"black"}.}

\item{label_size}{The size of the labels to display. Corresponds to the \code{size}
option in the [ggplot2::aes()] mapping. The default is \code{4}.
for more color options.}

\item{...}{Other arguments to pass to [ggplot2::aes()]. These are
often aesthetics, used to set an aesthetic to a fixed value, like \code{color = "red"}
or \code{linewidth = 3}. They affect the appearance of the polygons used to render
the map (for example fill color, line color, line thickness, etc.). If any of
\code{color}/\code{colour}, \code{fill}, or \code{linewidth} are not specified they
are set to their default values of \code{color="black"}, \code{fill="white"},
and \code{linewidth=0.4}.}
}
\value{
A [ggplot2::ggplot] object that contains a basic
  US map with the described parameters. Since the result is a \code{ggplot}
  object, it can be extended with more [ggplot2::Geom] layers, scales, labels,
  themes, etc.
}
\description{
Conveniently plot basic India map
}
\examples{
plot_india()
plot_india(regions = "states")
plot_india(regions = "districts")

# Output is ggplot object so it can be extended
# with any number of ggplot layers
library(ggplot2)
plot_india(include = c("GJ", "MH", "MP", "UP")) +
  labs(title = "Indian States")


}
\seealso{
[indiamap], [ggplot2::theme()]
}
