% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.dataset.R
\name{march.dataset.loadFromDataFrame}
\alias{march.dataset.loadFromDataFrame}
\title{Construct a dataset from a data.frame or a matrix.}
\usage{
march.dataset.loadFromDataFrame(
  dataframe,
  MARGIN = 2,
  weights = NA,
  missingDataRep = NA,
  covariates = NULL
)
}
\arguments{
\item{dataframe}{A \code{\link{data.frame}} containing the dataset.}

\item{MARGIN}{The dimension of the matrix/data.frame that contains the sequences and of the covariates (resp 1 for the column, 
2 for the rows).}

\item{weights}{If specified, contains the weight of each sequence.}

\item{missingDataRep}{If specified, the symbol representing a missing data.}

\item{covariates}{If specified, a three dimensional array of integers, representing the covariates. The data for the i-th covariates
should be in [, , i]. If the data are column-wise (respectively row-wise), each table of covariates should be column-wise (respectively row-wise).
If we only have one covariate, we can simply pass a two-dimensional array. The covariates should be coded as integers from 1 to the number of possible outputs.}
}
\value{
A \code{\link{march.Dataset-class}} object containing the data contructed from the matrix or data.frame.
}
\description{
The function creates a \code{\link{march.Dataset-class}} from a \emph{dataframe} or a \emph{matrix}, where each row (resp. column) represents 
an independent data series when \emph{MARGIN} is 2 (resp. 1).
}
\examples{
# Create a march dataset from the sleep_df dataframe included in the march package.
sleep <- march.dataset.loadFromDataFrame(sleep_df, MARGIN = 2,
                            weights = NA, missingDataRep = NA)

# Each row of sleep_df contains the data for one subject, so MARGIN was set to 2.

# Most of the subjects have been observed during 7 consecutive years,
# but some subjects have been observed for only 5 or 6 years.
# To load only the first 5 observations of each subject:
sleep.5 <- march.dataset.loadFromDataFrame(sleep_df[,1:5], MARGIN = 2 ,
                            weights = NA, missingDataRep = NA)

# The sleep data are not weighted.
# To add a weighting variable taking value 1.5 for the 500 first subjects
# and value 0.5 for the 500 next:
weighting <- rep(1.5,1000)
weighting[501:1000] <- rep(0.5,500)
sleep.w <- march.dataset.loadFromDataFrame(sleep_df, MARGIN = 2,
                           weights = weighting, missingDataRep = NA)

# We add two covariates to the sleep data. The first is the sex of the subject
# (1 for male, 2 for female), and the second is the age range (1 for younger
# than 40, 2 for older than 40). We suppose that the first 250 sequences 
# represent men older than 40, the next 250 sequences men younger than 40,
# the next 250 women younger than 40 and the last 250 women older than 40.
# We build the two tables of covariates and bind them together to obtain a
# three dimensional array that can be handled by MARCH.
covariates.sex<-rbind(matrix(1,500,7),matrix(1,500,7))
covariates.age<-rbind(matrix(1,250,7), matrix(2,250,7), matrix(1,250,7),
                    matrix(2,250,7))
covariates<-array(0,c(1000,7,2))
covariates[ , ,1]<-covariates.sex
covariates[ , ,2]<-covariates.age
# We build a MARCH dataset object containing these covariates.
sleep.covariates<-march.dataset.loadFromDataFrame(sleep_df,covariates=covariates)
}
\author{
Ogier Maitre
}
