% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_figures.R
\name{vert_bow_tie}
\alias{vert_bow_tie}
\alias{s_vert_bow_tie}
\alias{hor_bow_tie}
\alias{s_hor_bow_tie}
\title{Coordinates of  bow ties}
\usage{
vert_bow_tie(
  size.x = 10,
  size.y = size.x,
  pos.x = 0,
  shd = NA,
  lty = 1,
  lwd = 3
)

s_vert_bow_tie(
  size.x = 10,
  size.y = size.x,
  pos.x = 0,
  shd = NA,
  lty = 1,
  lwd = 3
)

hor_bow_tie(
  size.x = 10,
  size.y = size.x,
  pos.x = 0,
  shd = NA,
  lwd = 3,
  lty = 1
)

s_hor_bow_tie(
  size.x = 10,
  size.y = size.x,
  pos.x = 0,
  shd = NA,
  lwd = 3,
  lty = 1
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 10}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x}

\item{pos.x}{numeric, define the position on the x axis. Default is 0}

\item{shd}{character, define the color of the figure. Default is NA, which results in a transparent figure}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{lwd}{integer, define the line width of the figure. Default is 3}
}
\value{
Return the coordinates for drawing a vertical bow tie

Return the coordinates for drawing a single vertical bow tie

Return the coordinates for drawing a vertical bow tie

Return the coordinates for drawing a single horizontal bow tie
}
\description{
Define the coordinates for drawing bow ties composed of two triangles
}
\details{
vert_bow_tie() Define the coordinates for drawing a vertical bow tie composed of two triangles
}
\section{Functions}{
\itemize{
\item \code{s_vert_bow_tie()}: Coordinates of a single vertical bow tie

Define the coordinates for drawing a single vertical bow tie composed of two triangles, to be used in shape()

\item \code{hor_bow_tie()}: Coordinates of an horizontal bow tie

Define the coordinates for drawing an horizontal bow tie composed of two triangles

\item \code{s_hor_bow_tie()}: Coordinates of a single horizontal bow tie

Define the coordinates for drawing a single horizontal bow tie composed of two triangles, to be used in shape()

}}
\examples{
# return the default coordinates for drawing a vertical bow tie
vert_bow_tie()
# change the coordinates for drawing a smaller bow tie
vert_bow_tie(size.x = 5)
# return the default coordinates for drawing a bow tie
s_vert_bow_tie()
# change the coordinates for drawing a smaller bow tie
s_vert_bow_tie(size.x = 5)
# return the default coordinates for drawing a vertical bow tie
hor_bow_tie()
# change the coordinates for drawing a smaller bow tie
hor_bow_tie(size.x = 5)
# return the default coordinates for drawing a single horizontal bow tie
s_hor_bow_tie()
# change the coordinates for drawing a smaller bow tie
s_hor_bow_tie(size.x = 5)
}
