% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dance.R
\name{dance_remove}
\alias{dance_remove}
\title{Remove your logging history.}
\usage{
dance_remove()
}
\value{
Either \code{TRUE} if the log was removed or \code{FALSE} if the log
does not exist (invisibly).
}
\description{
Remove your logging history.
}
\examples{
\dontrun{
library(knitr)

# Start recording
dance_start(value = TRUE)

# Execute some expressions
"Hello!"
4 + 4

# Stop recording
dance_stop()

# Access log of your session
kable(dance_tbl()[3:4, 1:5])

## |expr   |value  |path |contents |selection |
## |:------|:------|:----|:--------|:---------|
## |Hello! |Hello! |NA   |NA       |NA        |
## |4 + 4  |8      |NA   |NA       |NA        |

# Deletes the lgo of your session
dance_remove()

# With no log, dance_tbl() returns NULL invisibly.
withVisible(dance_tbl())

## $value
## NULL
##
## $visible
## FALSE

}
}
