/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractBijectiveVar;
import choco.cp.solver.variables.integer.BooleanVarImpl;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;

public class BoolVarNot
extends AbstractBijectiveVar {
    public BoolVarNot(Solver solver, String name, BooleanVarImpl variable) {
        super(solver, name, variable);
    }

    @Override
    public void remVal(int x) throws ContradictionException {
        if (x == 0) {
            this.variable.remVal(1);
        } else if (x == 1) {
            this.variable.remVal(0);
        }
    }

    @Override
    public void setInf(int x) throws ContradictionException {
        if (x == 1) {
            this.variable.setSup(0);
        }
    }

    @Override
    public void setMin(int x) throws ContradictionException {
        if (x == 1) {
            this.variable.setMax(0);
        }
    }

    @Override
    public void setSup(int x) throws ContradictionException {
        if (x == 0) {
            this.variable.setInf(1);
        }
    }

    @Override
    public void setMax(int x) throws ContradictionException {
        if (x == 0) {
            this.variable.setMin(1);
        }
    }

    @Override
    public boolean canBeInstantiatedTo(int x) {
        if (x == 0) {
            this.variable.canBeInstantiatedTo(1);
        } else if (x == 1) {
            this.variable.canBeInstantiatedTo(0);
        }
        return false;
    }

    @Override
    public boolean fastCanBeInstantiatedTo(int x) {
        if (x == 0) {
            this.variable.fastCanBeInstantiatedTo(1);
        } else if (x == 1) {
            this.variable.fastCanBeInstantiatedTo(0);
        }
        return false;
    }

    @Override
    public int getRandomDomainValue() {
        if (this.variable.isInstantiated()) {
            return this.getVal();
        }
        return this.variable.getRandomDomainValue();
    }

    @Override
    public int getNextDomainValue(int i) {
        int inf = this.getInf();
        if (i < inf) {
            return inf;
        }
        int sup = this.getSup();
        if (i < sup) {
            return sup;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getPrevDomainValue(int i) {
        int sup = this.getSup();
        if (i > sup) {
            return sup;
        }
        int inf = this.getInf();
        if (i > inf) {
            return inf;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getInf() {
        if (this.variable.isInstantiated()) {
            return this.getVal();
        }
        return this.variable.getInf();
    }

    @Override
    public int getSup() {
        if (this.variable.isInstantiated()) {
            return this.getVal();
        }
        return this.variable.getSup();
    }

    @Override
    public int getValue() {
        return Math.abs(this.variable.getValue() - 1);
    }

    @Override
    public boolean updateInf(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (x == 1) {
            return this.variable.instantiate(0, cause, forceAwake);
        }
        if (x > 1) {
            this.propagationEngine.raiseContradiction(cause);
        }
        return false;
    }

    @Override
    public boolean updateInf(int x, int idx) throws ContradictionException {
        if (x == 1) {
            return this.variable.instantiate(0, idx);
        }
        if (x > 1) {
            this.propagationEngine.raiseContradiction(idx, this, null);
        }
        return false;
    }

    @Override
    public boolean updateSup(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (x == 0) {
            return this.variable.instantiate(1, cause, forceAwake);
        }
        if (x < 0) {
            this.propagationEngine.raiseContradiction(cause);
        }
        return false;
    }

    @Override
    public boolean updateSup(int x, int idx) throws ContradictionException {
        if (x == 0) {
            return this.variable.instantiate(1, idx);
        }
        if (x < 0) {
            this.propagationEngine.raiseContradiction(idx, this, null);
        }
        return false;
    }

    @Override
    public boolean removeVal(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (x == 0) {
            return this.variable.instantiate(0, cause, forceAwake);
        }
        if (x == 1) {
            return this.variable.instantiate(1, cause, forceAwake);
        }
        return false;
    }

    @Override
    public boolean removeVal(int x, int idx) throws ContradictionException {
        if (x == 0) {
            return this.variable.instantiate(0, idx);
        }
        if (x == 1) {
            return this.variable.instantiate(1, idx);
        }
        return false;
    }

    @Override
    public boolean removeInterval(int a, int b, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (a <= this.getInf()) {
            return this.updateInf(b + 1, cause, forceAwake);
        }
        if (this.getSup() <= b) {
            return this.updateSup(a - 1, cause, forceAwake);
        }
        return false;
    }

    @Override
    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        if (a <= this.getInf()) {
            return this.updateInf(b + 1, idx);
        }
        if (this.getSup() <= b) {
            return this.updateSup(a - 1, idx);
        }
        return false;
    }

    @Override
    public boolean instantiate(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (x == 0) {
            return this.variable.instantiate(1, cause, forceAwake);
        }
        if (x == 1) {
            return this.variable.instantiate(0, cause, forceAwake);
        }
        this.propagationEngine.raiseContradiction(cause);
        return false;
    }

    @Override
    public boolean instantiate(int x, int idx) throws ContradictionException {
        if (x == 0) {
            return this.variable.instantiate(1, idx);
        }
        if (x == 1) {
            return this.variable.instantiate(0, idx);
        }
        this.propagationEngine.raiseContradiction(idx, this, null);
        return false;
    }

    @Override
    public void setVal(int x) throws ContradictionException {
        if (x == 0) {
            this.variable.setVal(1);
        } else if (x == 1) {
            this.variable.setVal(0);
        } else {
            this.variable.setVal(x);
        }
    }

    @Override
    public int getVal() {
        return Math.abs(this.variable.getVal() - 1);
    }

    @Override
    public boolean isInstantiatedTo(int x) {
        if (x == 0) {
            return this.variable.isInstantiatedTo(1);
        }
        return x == 1 && this.variable.isInstantiatedTo(0);
    }

    @Override
    public String toString() {
        return this.name + ":" + (this.isInstantiated() ? Integer.valueOf(this.getVal()) : "?");
    }

    @Override
    public String pretty() {
        return String.format("not (%s)", this.variable.getName());
    }
}

