% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{\%fn\%}
\alias{\%fn\%}
\title{Create Function}
\usage{
lhs \%fn\% rhs
}
\arguments{
\item{lhs}{symbol used to denote the function argument}

\item{rhs}{expression that is converted to the function body. \code{rhs} may need to be surrounded
by parentheses is other infix operators are used due to precedence rules.}
}
\value{
a function
}
\description{
Syntactic sugar for creating a single-variable function. Can be conveniently used in \code{\link{Match}} statements.
}
\examples{
Match(
  "abc",
  is.numeric  -> -1,
  i \%fn\% grepl("bc", i) -> 0,
  is.character -> 1
)

print_sq_log <- i \%fn\% print(sqrt(log(i)))
print_sq_log(10)

}
