% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{neighbour_idx}
\alias{neighbour_idx}
\title{Get all indices in neighbourhood}
\usage{
neighbour_idx(mat, idx, mask = NULL, diagonal = TRUE,
  include.idx = FALSE)
}
\arguments{
\item{mat}{matrix or data.frame}

\item{idx}{two-element vector}

\item{mask}{logical matrix; optional}

\item{diagonal}{include diagonal neighbours}

\item{include.idx}{include current index}
}
\description{
Get all indices in neighbourhood
}
\examples{
mat <- matrix(0, 3, 3)
neighbour_idx(mat, c(1, 2))
neighbour_idx(mat, c(1, 2), diagonal = FALSE)
neighbour_idx(mat, c(1, 2), diagonal = FALSE, include.idx = TRUE)
# With mask
mat <- matrix(0, 3, 4)
mask <- m(FALSE, FALSE, TRUE, TRUE |
          FALSE, FALSE, FALSE, FALSE |
          TRUE, TRUE, FALSE, TRUE)
neighbour_idx(mat, c(1, 2), mask = mask)
}
